%define _libexecdir /usr/libexec

Name: drbd-reactor
Version: 1.9.0
Release: alt2
Summary: React to DRBD events via plugins.

Group: System/Servers
License: Apache-2.0
URL: https://www.github.com/LINBIT/drbd-reactor
Vcs: https://www.github.com/LINBIT/drbd-reactor.git
Source: %name-%version.tar
ExclusiveArch: x86_64 aarch64 loongarch64 ppc64le

BuildRequires(pre): rpm-macros-rust rpm-macros-systemd
BuildRequires: rust-cargo
BuildRequires: systemd-devel
BuildRequires: /proc

Requires: drbd-utils >= 9.29.0

%description
Daemon monitoring the state of DRBD resources, and executing plugins
acting on state changes.
Plugins can for example monitor resources or promote DRBD resources.

%prep
%setup
sed -i 's!)/lib/systemd/!)/usr/lib/systemd/!g' Makefile

mkdir -p .cargo
cat >> .cargo/config <<EOF
[source.crates-io]
replace-with = "vendored-sources"

[source.vendored-sources]
directory = "vendor"

[term]
verbose = true
quiet = false

[install]
root = "%buildroot%_prefix"

[build]
rustflags = ["-Copt-level=3", "-Cdebuginfo=1"]

[profile.release]
strip = false
EOF


%build
%rust_build

%install
%makeinstall_std
install -D -m644 example/ctl.completion.bash %buildroot%_datadir/bash-completion/completions/drbd-reactorctl

%post
%post_systemd_postponed %name.service

%preun
%preun_systemd %name.service

%check
%rust_test

%files
%doc README.md example/drbd-reactor-reload.path example/drbd-reactor-reload.service example/drbd-reactor.toml example/on-no-quorum-io-error.sh
%config(noreplace) %_sysconfdir/drbd-reactor.toml
%_sysconfdir/drbd-reactor.d
%systemd_unitdir/drbd-reactor.service
%systemd_unitdir/ocf.rs@.service
%_sbindir/drbd-reactor
%_sbindir/drbd-reactorctl
%_libexecdir/drbd-reactor/
%_libexecdir/drbd-reactor/ocf-rs-wrapper
%_datadir/bash-completion/completions/drbd-reactorctl
%_man1dir/drbd-reactor.1*
%_man1dir/drbd-reactorctl.1*
%_man5dir/drbd-reactor.toml.5*
%_man5dir/drbd-reactor.umh.5*
%_man5dir/drbd-reactor.promoter.5*
%_man5dir/drbd-reactor.agentx.5*
%_man5dir/drbd-reactor.debugger.5*
%_man5dir/drbd-reactor.prometheus.5*

%changelog
