%def_without check

Name: drbd9
Version: 9.2.12
Release: alt1
%define githash 2da6f528dc4ab3fd25c511f7b03531100e54ab08

Summary: The Linux kernel code for DRBD9
License: GPLv2
Group: System/Kernel and hardware
# ExclusiveArch: x86_64 aarch64 ppc64le
BuildArch: noarch

Url: https://github.com/LINBIT/drbd.git
Source0: %name-%version.tar
Source1: %name-headers-%version.tar
Patch: %name-%version.patch

BuildRequires(pre): rpm-build-kernel
%if_with check
BuildRequires: coccinelle >= 1.0.8
BuildRequires: libelf-devel
BuildRequires: kernel-headers-modules-%kernel_latest
%endif

%description
DRBD, developed by LINBIT, is a software that allows RAID 1 functionality over
TCP/IP and RDMA for GNU/Linux. DRBD is a block device which is designed
to build high availability clusters and software defined storage by providing
a virtual shared device which keeps disks in nodes synchronised using TCP/IP
or RDMA. This simulates RAID 1 but avoids the use of uncommon hardware
(shared SCSI buses or Fibre Channel).

%package -n kernel-source-%name
Summary: The Linux kernel code for DRBD9.
Group: Development/Kernel
BuildArch: noarch

%description -n kernel-source-%name
The Linux kernel code for DRBD9.

%prep
%setup -q
tar -xf %SOURCE1 -C drbd/drbd-headers
echo "GIT-hash: %githash" >drbd/.drbd_git_revision
%patch -p1

%build

%install
mkdir -p %kernel_srcdir
cd ..
tar -cf %kernel_srcdir/kernel-source-%name-%version.tar %name-%version

%check
make -C drbd KDIR=/lib/modules/*-*-*/build -k

%files -n kernel-source-%name
%attr(0644,root,root) %kernel_src/kernel-source-%name-%version.tar

%files
%doc README.md COPYING

%changelog
