Name: drwright
Version: 3.5
Release: alt2.27.gfa0bade
License: GPL2
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Attic/drwright
Summary: A program that reminds you to take wrist breaks
# https://gitlab.gnome.org/Archive/drwright.git
Source: %name-%version.tar

# Automatically added by buildreq on Mon Aug 07 2023 (-bi)
# optimized out: at-spi2-atk debugedit elfutils fontconfig-devel glib2-devel glibc-kernheaders-generic glibc-kernheaders-x86 gnu-config gtk-builder-convert libX11-devel libXext-devel libat-spi2-core libatk-devel libcairo-devel libcairo-gobject libcairo-gobject-devel libcanberra-devel libcanberra-gtk-common-devel libcanberra-gtk3 libctf-nobfd0 libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libgpg-error libgtk+3-devel libharfbuzz-devel libjson-glib libpango-devel libwayland-client libwayland-cursor libwayland-egl perl perl-Encode perl-XML-Parser perl-parent pkg-config python3 python3-base rpm-build-file sh4 shared-mime-info termutils xml-common xml-utils xorg-proto-devel
BuildRequires: desktop-file-utils gnome-common intltool libXScrnSaver-devel libcanberra-gtk3-devel libnotify-devel

BuildRequires: gnome-settings-daemon-devel

%description
WARNING: no GUI for settings except dconf-editor! (key
/org/gnome/settings-daemon/plugins/typing-break/)

"typing break" drwright - Typing monitor to force typing breaks

It's a program that forces you to take regular breaks to prevent RSI
(Repetitive Strain Injury). It's similar to workrave. It can be found in GNOME
control center as "typing break".

It used to be part of GNOME 2's main core, but is now packaged separately.

Features
* You can specify the work interval (how much time you want to work between
  breaks) and a break interval (how long your break will be).
* It also allows postponing of breaks.
* There is an option to lock the screen in case you want to step out
  indefinetely (v3.2.3).

%prep
%setup
%__subst 's/^gsd_plugin_LTLIBRARIES/gsd_plugin_LTLIBRARIES_turnoff/' src/Makefile.am
%__subst 's/^ccpanels_LTLIBRARIES/ccpanels_LTLIBRARIES_turnoff/' src/Makefile.am
%__subst 's/^gsd_plugin_DATA/gsd_plugin_DATA_turnoff/' src/Makefile.am

%build
./autogen.sh
%configure
%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_sysconfdir/xdg/autostart/
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-key=OnlyShowIn \
	--set-key=Exec \
	--set-value=%_libexecdir/%name/gnome-typing-monitor \
	src/gnome-typing-break-panel.desktop
desktop-file-install --dir %buildroot%_sysconfdir/xdg/autostart/ \
	--remove-key=X-GNOME-Settings-Panel \
	--set-key=NoDisplay \
	--set-value=true \
	%buildroot%_desktopdir/gnome-typing-break-panel.desktop

%find_lang %name --with-gnome

%files -f %name.lang
%doc AUTHORS NEWS
%_sysconfdir/xdg/autostart/*.desktop
%_libexecdir/%name/
%_datadir/glib-2.0/schemas/*
%_iconsdir/hicolor/*/apps/*
%_desktopdir/*
%_datadir/locale/sr@Latn/LC_MESSAGES/drwright.mo

%changelog
