%def_disable clang

Name: dtkcommon
Version: 5.6.34
Release: alt1

Summary: Deepin desktop schemas

License: BSD-3-Clause and CC0-1.0
Group: System/Configuration/Other
Url: https://github.com/linuxdeepin/dtkcommon

Packager: Leontiy Volodin <lvol@altlinux.org>

Source: %url/archive/%version/%name-%version.tar.gz

%if_enabled clang
BuildRequires(pre): clang-devel
%else
BuildRequires(pre): gcc-c++
%endif
BuildRequires(pre): rpm-build-ninja
BuildRequires: cmake

%description
%summary.

%package -n dtk6-common-configs
Summary: Deepin desktop configs
Group: System/Configuration/Other
BuildArch: noarch
Provides: dtk5-common-schemas = %EVR

%description -n dtk6-common-configs
%summary.

%package -n dtk6-common-devel
Summary: Development files for %name
Group: Development/Other
Provides: dtk5-common = %EVR
Provides: dtk5-common-devel = %EVR
Obsoletes: dtk5-common-devel < %EVR

%description -n dtk6-common-devel
The package provides development files for %name.

%prep
%setup

%build
%if_enabled clang
export CC="clang"
export CXX="clang++"
export AR="llvm-ar"
%endif

%cmake \
  -GNinja \
  -DCMAKE_BUILD_TYPE=RelWithDebInfo \
  -DDVERSION=%version \
  -DDTK_VERSION=%version \
  -DLIB_INSTALL_DIR=%_libdir \
  -DARCH=%_arch \
#
cmake --build "%_cmake__builddir" -j%__nprocs

%install
%cmake_install

%files -n dtk6-common-configs
%doc LICENSE README.md
%_datadir/dsg/configs/org.deepin.dtk.preference.json

%files -n dtk6-common-devel
%_libdir/cmake/Dtk/DtkConfig.cmake
%_libdir/cmake/Dtk6/Dtk6Config.cmake
%_libdir/cmake/DtkBuildHelper/DtkBuildHelperConfig.cmake
%_libdir/cmake/DtkBuildHelper/DtkBuildHelperConfigVersion.cmake

%changelog
