%def_enable snapshot

%define ver_major 0.6
%define rdn_name app.drey.EarTag

%def_enable check

Name: eartag
Version: %ver_major.4
Release: alt1

Summary: Small and simple audio file tag editor
License: MIT
Group: Sound
Url: https://gitlab.gnome.org/World/eartag

Vcs: https://gitlab.gnome.org/World/eartag.git

%if_disabled snapshot
Source: %url/-/archive/%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

%define gtk_ver 4.16
%define adwaita_ver 1.6

Requires: typelib(Adw) = 1

BuildArch: noarch

%add_python3_path %_datadir/%name

Requires: python3(acoustid)

BuildRequires(pre): rpm-macros-meson rpm-build-python3 rpm-build-gir
BuildRequires: meson blueprint-compiler
BuildRequires: pkgconfig(gtk4) >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver typelib(Adw)
%{?_enable_check:BuildRequires: python3(pytest)
BuildRequires: python3-module-pygobject3
BuildRequires: python3(mutagen) python3(magic) python3-module-Pillow
BuildRequires: python3(acoustid)}
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils}

%description
%summary

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %rdn_name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_datadir/%name/
%_desktopdir/%rdn_name.desktop
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_iconsdir/hicolor/*/apps/%{rdn_name}*.svg
%_datadir/metainfo/%rdn_name.metainfo.xml
%doc README*

%changelog
