%def_disable snapshot
%define __isa_bits %(s="%_lib"; s=${s#lib}; echo "${s:-32}")

%define xdg_name com.github.wwmm.easyeffects

Name: easyeffects
Version: 7.2.3
Release: alt1

Summary: Audio effects for Pipewire applications
License: GPL-3.0-or-later
Group: Sound
Url: https://github.com/wwmm/%name

Vcs: https://github.com/wwmm/easyeffects.git

%if_disabled snapshot
Source: %url/archive/v%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

%define sigc_ver 3.0.6
%define gtk_ver 4.10
%define adwaita_ver 1.2.0
%define pw_api_ver 0.3
%define pw_ver 0.3.58
%define lv2_ver 1.18.2
%define lilv_ver 0.22
%define calf_ver 0.90.1
%define lsp_ver 1.2.10

Requires: pipewire >= %pw_ver dconf
Requires: ladspa-zam-plugins
Requires: calf-plugins >= %calf_ver
Requires: lv2-lsp-plugins >= %lsp_ver
Requires: lv2-mda-plugins

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson gcc-c++ pkgconfig(sigc++-3.0) >= %sigc_ver libfmt-devel
BuildRequires: yelp-tools desktop-file-utils /usr/bin/appstream-util
BuildRequires: libgtk4-devel >= %gtk_ver pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: pkgconfig(libportal-gtk4)
BuildRequires: pkgconfig(libpipewire-%pw_api_ver) >= %pw_ver
BuildRequires: nlohmann-json-devel
BuildRequires: pkgconfig(gsl)
BuildRequires: lv2-devel >= %lv2_ver
BuildRequires: ladspa_sdk
BuildRequires: libsndfile-devel libsamplerate-devel libfftw3-devel
BuildRequires: libbs2b-devel
BuildRequires: liblilv-devel >= %lilv_ver
BuildRequires: libebur128-devel
BuildRequires: pkgconfig(speexdsp)
BuildRequires: pkgconfig(rnnoise)
BuildRequires: pkgconfig(speex)
BuildRequires: pkgconfig(soundtouch)
BuildRequires: zita-convolver-devel
BuildRequires: libdbus-devel
BuildRequires: libtbb-devel

%description
This application used to be called PulseEffects but it was renamed to
EasyEffects after we started to use GTK4 and replaced GStreamer by native
PipeWire filters.

%prep
%setup
%if "%__isa_bits" == "32"
sed -i 's/tbb/tbb32/' src/meson.build
%endif

%build
%meson
%meson_build

%install
%meson_install
# system-wide config directory
#mkdir -p %buildroot%_sysconfdir/EasyEffects

%find_lang --with-gnome --output=%name.lang %name %name-news

%files -f %name.lang
%_bindir/%name
#%dir %_sysconfdir/EasyEffects
%_desktopdir/%xdg_name.desktop
%_datadir/glib-2.0/schemas/%xdg_name.*gschema.xml
%_datadir/dbus-1/services/%xdg_name.service
%_iconsdir/hicolor/*/apps/%{xdg_name}*.svg
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc README* CHANGELOG.*

%changelog
