Name: eduke32
Version: 20230123.10167
Release: alt1
Summary: Source port of Duke Nukem 3D
License: GPL-2.0-only
Group: Games/Arcade
Url: https://www.eduke32.com/
Packager: Artyom Bystrov <arbars@altlinux.org>

Source: eduke32-%version.tar.xz
Source1: %{name}_32x32.png
Source2: %{name}_48x48.png
Source3: %{name}_64x64.png
Source4: %{name}_128x128.png
Source5: %name.desktop
Source6: %name-demo-install.sh
Source7: %name-demo-install.1
BuildRequires: dos2unix
BuildRequires: gcc-c++
BuildRequires: help2man
BuildRequires: nasm
BuildRequires: pkg-config
BuildRequires: libSDL2_mixer-devel
BuildRequires: libalsa-devel
BuildRequires: libflac-devel
BuildRequires: libgtk+2-devel
BuildRequires: libpng-devel
BuildRequires: libSDL2-devel
BuildRequires: libvorbis-devel
BuildRequires: libvpx-devel
BuildRequires: libGLU-devel
BuildRequires: imgui-devel

ExcludeArch: %ix86

%description
EDuke32 is a source port of the classic PC first person shooter Duke Nukem 3D
to Windows, Linux and OS X, which adds a ton of awesome features and
upgrades for regular players and an arsenal of editing functions and
scripting extensions for mod authors and map makers.

Note: You need 'Duke Nukem 3D' data files to play.
You can put them under '%_gamesdatadir/eduke32/' for all users
or '~/.eduke32/' only for yourself.
You can also play the shareware version. Use 'eduke32-demo-install' to
install the shareware files.

%package mapeditor
Summary: Eduke32 map editor
Group: Games/Arcade

%description mapeditor
Eduke32 maps editor based on BUILD engine

%prep
%setup
cp %SOURCE1 .
cp %SOURCE2 .
cp %SOURCE3 .
cp %SOURCE4 .
cp %SOURCE5 .
cp %SOURCE6 .
cp %SOURCE7 .

sed -i 's/ -save-temps=obj / /g' GNUmakefile

%build
export CFLAGS='%optflags -Wno-format'
make PACKAGE_REPOSITORY=1 \
     PRETTY_OUTPUT=1 \
     RELEASE=1 \
     SDL_TARGET=2 \
     BASECFLAGS="%{optflags}" \
%{?_smp_mflags} \
     VC_REV=%version

dos2unix source/build/buildlic.txt

%install
install -Dm 0755 %name %buildroot%_bindir/%name
install -Dm 0755 mapster32 %buildroot%_bindir/mapster32
# shareware demo installer script
install -Dm 0755 %name-demo-install.sh %buildroot%_bindir/%name-demo-install
# data files and help files for editor
install -Dm 0644 package/sdk/SEHELP.HLP %buildroot%_gamesdatadir/%name/sehelp.hlp
install -Dm 0644 package/sdk/STHELP.HLP %buildroot%_gamesdatadir/%name/sthelp.hlp
install -Dm 0644 package/sdk/m32help.hlp %buildroot%_gamesdatadir/%name/m32help.hlp
install -Dm 0644 package/sdk/tiles.cfg %buildroot%_gamesdatadir/%name/tiles.cfg
install -Dm 0644 %name.desktop %buildroot%_desktopdir/%name.desktop
install -Dm 0644 %{name}_32x32.png %buildroot%_niconsdir/%name.png
install -Dm 0644 %{name}_48x48.png %buildroot%_liconsdir/%name.png
install -Dm 0644 %{name}_64x64.png %buildroot%_iconsdir/hicolor/64x64/apps/%name.png
install -Dm 0644 %{name}_128x128.png %buildroot%_iconsdir/hicolor/128x128/apps/%name.png

%files
%_bindir/%name
%_bindir/%name-demo-install
%dir %_gamesdatadir/%name/
%_gamesdatadir/%name/m32help.hlp
%_gamesdatadir/%name/sehelp.hlp
%_gamesdatadir/%name/sthelp.hlp
%_gamesdatadir/%name/tiles.cfg
%doc source/build/buildlic.txt
%_iconsdir/hicolor/*/apps/%name.png
%_desktopdir/%name.desktop

%files mapeditor
%_bindir/mapster32

%changelog
