%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%def_disable hipe
%def_enable stun
%def_enable sip
%def_enable mysql
%def_enable pgsql
%def_enable sqlite
%def_enable pam
%def_enable zlib
%def_enable tools
%def_enable lua

Name: ejabberd
Version: 21.12
Release: alt4
Summary: Fault-tolerant distributed Jabber server written in Erlang
License: GPL-2.0 with OpenSSL-exception
Group: System/Servers
Url: https://www.process-one.net/en/ejabberd/

BuildArch: noarch

# https://github.com/processone/ejabberd.git
Source: %name-%version.tar

Source1: %name-%version-alt.tar

Source2: %name.watch

Source3: ejabberd.service

# Use ejabberd as an example for PAM service name
Patch4: ejabberd-fedora-enable-systemd-notification-if-available.patch

Patch11: ejabberd-alt-version.patch
# https://github.com/processone/ejabberd/issues/1037
Patch12: ejabberd-alt-erllibs-path.patch

Patch13: ejabberd-alt-dont-rebuild-translation.patch

BuildRequires(pre): jabber-common >= 0.2
BuildRequires(pre): rpm-build-erlang
BuildRequires: erlang-devel erlang-otp-devel libcom_err-devel libexpat-devel libssl-devel zlib-devel
BuildRequires: /usr/bin/rebar
BuildRequires: erlang-lager
BuildRequires: erlang-p1_utils
BuildRequires: erlang-cache_tab
BuildRequires: erlang-fast_tls
BuildRequires: erlang-stringprep
BuildRequires: erlang-fast_xml
BuildRequires: erlang-xmpp
BuildRequires: erlang-fast_yaml
BuildRequires: erlang-jiffy
BuildRequires: erlang-p1_oauth2
BuildRequires: erlang-jose
BuildRequires: erlang-eimp
BuildRequires: erlang-sd_notify
BuildRequires: erlang-pkix
BuildRequires: erlang-mqtree
BuildRequires: erlang-idna
BuildRequires: erlang-yconf
BuildRequires: erlang-p1_acme
%{?_enable_stun:BuildRequires: erlang-stun}
%{?_enable_sip:BuildRequires: erlang-esip}
%{?_enable_mysql:BuildRequires: erlang-p1_mysql}
%{?_enable_pgsql:BuildRequires: erlang-p1_pgsql}
%{?_enable_sqlite:BuildRequires: erlang-sqlite3 libsqlite3-devel}
%{?_enable_pam:BuildRequires: erlang-epam}
%{?_enable_zlib:BuildRequires: erlang-ezlib}
%{?_enable_lua:BuildRequires: erlang-luerl}

Requires: erlang
Requires: jabber-common >= 0.2
Requires: su

# workaround for bug #36925
Requires: erlang-lager

Provides: %name-pam = %EVR
Obsoletes: %name-pam

%add_erlang_req_modules_skiplist Elixir.Ejabberd.Config
%add_erlang_req_modules_skiplist Elixir.Ejabberd.Config.Store
%add_erlang_req_modules_skiplist Elixir.Ejabberd.ConfigUtil
%add_erlang_req_modules_skiplist Elixir.Kernel.ParallelCompiler
%add_erlang_req_modules_skiplist Elixir.Logger
%add_erlang_req_modules_skiplist Elixir.Logger.Config
%add_erlang_req_modules_skiplist Elixir.Logger.Utils
%add_erlang_req_modules_skiplist eredis
%add_erlang_req_modules_skiplist eredis_sub

%description
ejabberd is a Free and Open Source distributed fault-tolerant Jabber
server. It writen mostly in Erlang.

The main features of ejabberd is:

* Truly portable
* Distributed
* Fault-tolerance
* Built-in Multi-User Chat service
* Built-in IRC transport
* Built-in Publish-Subscribe service
* Built-in Jabber Users Directory service based on users vCards
* Built-in web-based administration interface
* Built-in HTTP Polling service
* SSL support
* Support for LDAP authentification
* Ability to interface with external components (JIT, MSN-t, Yahoo-t, etc)
* Migration from jabberd14 is possible
* Mostly XMPP-compliant
* Support for JEP-0030 (Service Discovery).
* Support for JEP-0039 (Statistics Gathering).
* Support for xml:lang

%prep
%setup -a 1
%patch4 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1

# Upstream seems to import erlang-xmpp and erlang-fast_xml in a way that isn't compatible with them
# being system libraries. We need to patch the include statements to fix this.
# https://github.com/processone/ejabberd/pull/1446/
find . -name "*.hrl" | xargs sed -i \
    "s/include(\"fxml.hrl/include_lib(\"fast_xml\/include\/fxml.hrl/"
find . -name "*.erl" | xargs sed -i "s/include(\"jid.hrl/include_lib(\"xmpp\/include\/jid.hrl/"
find . -name "*.hrl" | xargs sed -i "s/include(\"ns.hrl/include_lib(\"xmpp\/include\/ns.hrl/"
find . -name "*.erl" | xargs sed -i "s/include(\"xmpp.hrl/include_lib(\"xmpp\/include\/xmpp.hrl/"
find . -name "*.hrl" | xargs sed -i \
    "s/include(\"xmpp_codec.hrl/include_lib(\"xmpp\/include\/xmpp_codec.hrl/"

# A few dependencies are configured to be found in the deps folder instead of in system libs
# https://github.com/processone/ejabberd/issues/1850
perl -p -i -e "s|deps/p1_utils/include|$(rpm -ql erlang-p1_utils | grep -E '/include$' )|g" rebar.config
perl -p -i -e "s|deps/fast_xml/include|$(rpm -ql erlang-fast_xml | grep -E '/include$' )|g" rebar.config
perl -p -i -e "s|deps/xmpp/include|$(rpm -ql erlang-xmpp | grep -E '/include$' )|g"   rebar.config

sed -i -e "s:@version@:%version:g" configure.ac

# additional update for patch 12
sed -i -e "s|@ERL_LIBS@|%_erllibdir/%name-%version:|g" ejabberdctl.template

%build
%autoreconf
%configure \
	--datarootdir=%_datadir \
	--libdir=%_erllibdir \
	--localstatedir=%_var \
	--enable-system-deps \
	--enable-odbc \
	%{subst_enable hipe} \
	%{subst_enable stun} \
	%{subst_enable sip} \
	%{subst_enable mysql} \
	%{subst_enable pgsql} \
	%{subst_enable sqlite} \
	%{subst_enable pam} \
	%{subst_enable zlib} \
	%{subst_enable tools} \
	%{subst_enable lua} \
	%nil

#--enable-user=ejabberd

%rebar_compile

%install
%makeinstall DESTDIR=%buildroot

rm -rf %buildroot%_defaultdocdir/%name

(cd %name-%version-alt && find . -type f |cpio -pumd %buildroot)

mkdir -p %buildroot%_localstatedir/ejabberd %buildroot%_logdir/ejabberd \
	%buildroot%_sysconfdir/sysconfig/ %buildroot%_lockdir/ejabberd
mv %buildroot%_sysconfdir/%name/ejabberdctl.cfg %buildroot%_sysconfdir/sysconfig/ejabberd

install -p -m 0644 sql/mysql.sql %buildroot%_erllibdir/%name-%version/priv/sql/
install -p -m 0644 sql/pg.sql    %buildroot%_erllibdir/%name-%version/priv/sql/

install -D -m 0644 %SOURCE3 %buildroot%_unitdir/ejabberd.service

%pre
%_sbindir/groupadd -r -f ejabberd &>/dev/null
%_sbindir/useradd -r -g ejabberd  -d %_localstatedir/ejabberd -s /dev/null \
    -c 'ejabberd server' -M -n ejabberd &>/dev/null ||:

%post
%post_service %name
%_jabber_config

%preun
%preun_service %name

%files
%doc COPYING
%doc CODE_OF_CONDUCT.md
%doc README.md examples

%dir %_sysconfdir/ejabberd
%config(noreplace) %_sysconfdir/ejabberd/inetrc
%attr(640,root,ejabberd) %config(noreplace) %_sysconfdir/ejabberd/ejabberd.yml
%attr(0640,root,ejabberd) %config(noreplace) %_sysconfdir/sysconfig/ejabberd
%attr(0640,root,root) %config %_sysconfdir/logrotate.d/ejabberd
%config(noreplace) %_sysconfdir/pam.d/ejabberd
%config(noreplace) %_sysconfdir/pam.d/ejabberdctl

%_initdir/ejabberd
%_unitdir/%name.service
%attr(0755,root,ejabberd) %_sbindir/ejabberdctl

%_datadir/polkit-1/actions/ejabberdctl.policy
%_datadir/polkit-1/rules.d/51-ejabberdctl.rules

%_erllibdir/%name-%version

%_jabber_server_dir/ejabberd

%_man5dir/*
%_man8dir/*

%attr(1770,root,ejabberd) %dir %_localstatedir/ejabberd
%attr(1770,root,ejabberd) %dir %_logdir/ejabberd
%attr(1770,root,ejabberd) %dir %_lockdir/ejabberd

%changelog
