%define modename xslide
Name: emacs-%modename
Version: 0.2.2
Release: alt7

Summary: A GNU Emacs major mode for editing XSL stylesheets.
Group: Editors
License: GPL
Url: http://www.menteith.com/xslide
Packager: Emacs Maintainers Team <emacs@altlinux.org>
Source: %modename-%version.tar.gz
Source2: xslide-startup-script.el

%define WITH_CUSTOM_EL 0

%if %WITH_CUSTOM_EL
%define custom_eldir custom-%modename
Source1: %custom_eldir.tar.bz2
%endif

Obsoletes: emacs-mode-xslide
Provides: emacs-mode-xslide = %version

BuildArch: noarch
PreReq: emacs

# Automatically added by buildreq on Tue Sep 09 2008 (-bi)
BuildRequires: emacs-nox emacs-gnus

%description
Emacs is an advanced and extensible editor. An Emacs major mode
customizes Emacs for editing particular types of text documents. %modename
is a major mode for XSL stylesheets.

All Emacs Lisp code is byte-copmpiled, install %name-el for sources.

%package el
Summary: The Emacs Lisp sources for bytecode included in %name
Group: Development/Other
Requires: %name = %version-%release

%description el
%name-el contains the Emacs Lisp sources for the bytecode
included in the %name package, that extends the Emacs editor.

You need to install %name-el only if you intend to modify any of the
%name code or see some Lisp examples.

# Emacs
%define _emacs_startscriptsdir %_sysconfdir/emacs/site-start.d
%define modedir %_emacslispdir/%modename

%prep
%setup -q -n %modename-%version

%if %WITH_CUSTOM_EL
%__tar -jxf %SOURCE1 > %modename-%version
%endif

%build
%make_build

%install
%__mkdir_p %buildroot%modedir
%__install -m644 *.el *.elc *.xsl %buildroot%modedir

%if %WITH_CUSTOM_EL
%__mkdir_p %buildroot%modedir/%custom_eldir
%__install -m644 %custom_eldir/*.el %buildroot%modedir/%custom_eldir
%endif

%if %WITH_CUSTOM_EL
# Add to %modename-init.el entries from %custom_eldir directory
echo ";;; Apply some customization (fonts, colors, keystrokes ...) for %modename mode" >>%SOURCE2 
for f in %custom_eldir/*.el; do
echo -e "\t(load \"%modedir/$f\")" >>%SOURCE2 
done
%endif

%__install -pD -m644 %SOURCE2 %buildroot%_emacs_startscriptsdir/%{modename}.el

%files
%dir %modedir
%modedir/*.elc
%modedir/*.xsl

%if %WITH_CUSTOM_EL
%modedir/%custom_eldir/*.el
%endif

%config(noreplace) %_emacs_startscriptsdir/%modename.el
%doc *.TXT TODO NEWS ChangeLog

%files el
%modedir/*.el

%changelog
