%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%define build_type RelWithDebInfo
%set_verify_elf_method strict

%ifnarch %e2k
%def_with ispc
%else
# no ispc on e2k
%def_without ispc
%endif

%define libsuffix 4
%define soname 4

Name: embree
Version: 4.3.1
Release: alt1
Summary: Collection of high-performance ray tracing kernels developed at Intel
Group: Graphics
License: Apache-2.0
URL: https://embree.github.io

# https://github.com/embree/embree.git
Source: %name-%version.tar

Source1: %name.watch

Patch2000: %name-e2k.patch

BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libgif-devel
%if_with ispc
BuildRequires: ispc
%endif
BuildRequires: pkgconfig(glut)
BuildRequires: pkgconfig(glfw3)
BuildRequires: pkgconfig(xmu)
BuildRequires: pkgconfig(libjpeg)
BuildRequires: pkgconfig(libopenjp2)
BuildRequires: pkgconfig(libpng)
BuildRequires: pkgconfig(libtiff-4)
BuildRequires: pkgconfig(OpenImageIO)
BuildRequires: pkgconfig(tbb)

# https://github.com/embree/embree/issues/186
ExclusiveArch: aarch64 x86_64 %e2k

%description
A collection of high-performance ray tracing kernels intended to graphics 
application engineers that want to improve the performance of their application.

%package -n lib%{name}%{libsuffix}-%soname
Summary: Collection of high-performance ray tracing kernels developed at Intel
Group: System/Libraries

%description -n lib%{name}%{libsuffix}-%soname
A collection of high-performance ray tracing kernels intended to graphics 
application engineers that want to improve the performance of their application.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: lib%{name}%{libsuffix}-%soname = %EVR

%description devel
The %{name}-devel package contains libraries and header files for
applications that use %{name}.

%prep
%setup
%ifarch %e2k
%patch2000 -p1
%endif

%build
# limit parallel build
#if [ %__nprocs -gt 4 ] ; then
#	export NPROCS=4
#fi

%ifarch %e2k
%add_optflags -Wno-reduced-alignment -Wno-sign-compare -mno-avx
%endif

%cmake \
	-DCMAKE_BUILD_TYPE=%build_type \
	-DCMAKE_STRIP:STRING="" \
	-DEMBREE_IGNORE_CMAKE_CXX_FLAGS=OFF \
	-DEMBREE_TUTORIALS=OFF \
	-DEMBREE_COMPACT_POLYS=ON \
%if_without ispc
	-DEMBREE_ISPC_SUPPORT=OFF \
	-DEMBREE_MAX_ISA=DEFAULT \
%endif
	%nil

%cmake_build

%install
%cmakeinstall_std

# Remove unpackaged files
rm -rf %buildroot%_docdir/%{name}%{libsuffix}
rm -f %buildroot%prefix/%{name}-vars.*

%files -n lib%{name}%{libsuffix}-%soname
%doc LICENSE.txt
%doc README.md CHANGELOG.md readme.pdf third-party-programs-TBB.txt third-party-programs.txt
%_libdir/lib%{name}%{libsuffix}.so.%{soname}

%files devel
%_libdir/lib%{name}%{libsuffix}.so
%_includedir/%{name}%{libsuffix}/
%_libdir/cmake/%name-%version/
%_man3dir/*

%changelog
