%def_disable snapshot
%define beta %nil

%def_enable video
%def_enable curl
%def_enable webready
%def_disable ssh
%def_enable tests
%ifarch armh aarch64
%def_disable check
%else
%def_disable check
%endif

Name: exiv2
Version: 0.28.7
Release: alt1%beta

Summary: Command line tool to access EXIF data in image files
License: GPL-2.0-or-later
Group: Graphics
Url: http://www.exiv2.org

Vcs: https://github.com/Exiv2/exiv2.git

%if_disabled snapshot
Source: https://github.com/Exiv2/%name/archive/v%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif
Requires: lib%name = %EVR

BuildRequires(pre): rpm-macros-cmake
BuildRequires: /proc cmake gcc-c++ python3
BuildRequires: libexpat-devel zlib-devel
BuildRequires: libbrotli-devel libinih-devel
BuildRequires: doxygen xsltproc graphviz
%{?_enable_tests:BuildRequires: libgtest-devel}
%{?_enable_curl:BuildRequires: libcurl-devel}
%{?_enable_webready:BuildRequires: libcurl-devel libssh-devel libgcrypt-devel}
%{?_enable_check:BuildRequires: ctest}

%description
Exiv2 comprises of a C++ library and a command line utility to access
image metadata. Exiv2 supports full read and write access to the EXIF and
IPTC metadata, EXIF MakerNote support, extract and delete methods for
EXIF thumbnails, classes to access IFD and so on.

%package -n libexiv2
Summary: EXIF and IPTC metadata manipulation library
Group: Graphics

%description -n libexiv2
libexiv2 is a C++ library to access image metadata.

%package -n libexiv2-devel
Summary: Headers and links to compile against the exiv2 library
Group: Development/C
Requires: libexiv2 = %EVR

%description -n libexiv2-devel
This package contains all files which one needs to compile programs using the
exiv2 library.

%prep
%setup -n %name-%version

%build
%add_optflags -Wno-deprecated-declarations %(getconf LFS_CFLAGS)
%cmake \
	-DEXIV2_ENABLE_NLS:BOOL=ON \
	-DEXIV2_BUILD_SAMPLES:BOOL=OFF \
	-DEXIV2_ENABLE_BMFF:BOOL=ON \
	%{?_enable_video:-DEXIV2_ENABLE_VIDEO:BOOL=ON} \
	%{?_enable_curl:-DEXIV2_ENABLE_CURL:BOOL=ON} \
	%{?_enable_webready:-DEXIV2_ENABLE_WEBREADY:BOOL=ON} \
	%{?_enable_ssh:-DEXIV2_ENABLE_SSH:BOOL=ON} \
	%{?_enable_tests:-DEXIV2_BUILD_UNIT_TESTS:BOOL=ON}
%nil
%cmake_build

%install
%cmake_install
%find_lang exiv2

%check
%ctest

%files
%_bindir/%name
%_man1dir/*
%doc README* SECURITY* doc/ChangeLog

%files -n libexiv2 -f exiv2.lang
%_libdir/lib%name.so.*

%files -n libexiv2-devel
%_libdir/lib%name.so
%_includedir/%name/
%_pkgconfigdir/%name.pc
%_libdir/cmake/%name/


%changelog
