%define _unpackaged_files_terminate_build 1

Name: eza
Version: 0.23.4
Release: alt1

Summary: A modern alternative to ls
License: EUPL-1.2 and MIT and CC-BY-4.0
Group: System/Base
Url: https://eza.rocks/

VCS: https://github.com/eza-community/eza.git
Source: %name-%version.tar
Source1: %name-%version-vendor.tar
Patch0: %name-%version-alt.patch

BuildRequires: /proc
BuildRequires: rust
BuildRequires: rust-cargo
BuildRequires: libgit2-devel
BuildRequires: pandoc

Provides: exa = %EVR
Obsoletes: exa

%description
eza   is  a   modern  alternative   for  the   venerable  file-listing
command-line  program ls  that  ships with  Unix  and Linux  operating
systems, giving it more features  and better defaults. It uses colours
to  distinguish file  types  and metadata.  It  knows about  symlinks,
extended  attributes, and  Git. And  it's  small, fast,  and just  one
single binary.

%prep
%setup -a1
%patch0 -p1

sed -i -e '/^strip = true$/ s/true/false/' Cargo.toml

mkdir -p .cargo
cat > .cargo/config <<EOF
[source.crates-io]
replace-with = "vendored-sources"

[source.vendored-sources]
directory = "vendor"
EOF

%build
cargo build --release %{?_smp_mflags} --all-targets --offline

mkdir -p target/man
for manpage in eza.1 eza_colors.5 eza_colors-explanation.5; do
    pandoc --standalone -f markdown -t man "man/${manpage}.md" > "target/man/${manpage}"
done

%install
install -D -m755 target/release/eza %buildroot%_bindir/eza
ln -s eza %buildroot%_bindir/exa

# install completions
install -Dm 0644 completions/bash/eza %buildroot%_datadir/bash-completion/completions/eza
install -Dm 0644 completions/zsh/_eza %buildroot%_datadir/zsh/site-functions/_eza
install -Dm 0644 completions/fish/eza.fish %buildroot%_datadir/fish/vendor_completions.d/eza.fish

# install man pages
install -Dm644 target/man/*.1 -t %buildroot%_man1dir
install -Dm644 target/man/*.5 -t %buildroot%_man5dir

%check
cargo test --release --offline

%files
%doc LICENSE.txt README.md LICENSES/*
%_bindir/*
%_man1dir/*
%_man5dir/*
%_datadir/bash-completion/completions/eza
%_datadir/zsh/site-functions/_eza
%_datadir/fish/vendor_completions.d/eza.fish

%changelog
