%define _libexecdir %_prefix/libexec

%define xdg_name org.gnome.FileRoller
%define xdg_name1 org.gnome.ArchiveManager
%define ver_major 44
%define beta %nil
%def_disable packagekit
%def_enable libarchive
%def_enable nautilus_actions

Name: file-roller
Version: %ver_major.5
Release: alt1%beta

Summary: An archive manager for GNOME
Summary (ru_RU.UTF-8): Архиватор для GNOME
Group: File tools
License: GPL-2.0-or-later
Url: https://wiki.gnome.org/Apps/FileRoller

Vcs: https://gitlab.gnome.org/GNOME/file-roller.git

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
Patch1: %name-3.3.90-alt-zip_command.patch

%define glib_ver 2.36.0
%define gtk_ver 4.8
%define adw_ver 1.2
%define libarchive_ver 3.2
%define desktop_file_utils_ver 0.8
%define nau_api_ver 4
%define nautilus_ver 43
%define portal_ver 0.5

Requires: tar gzip bzip2 ncompress lzop binutils
Requires: arj lha unrar zip unzip p7zip lzma-utils xz
# since 44.4
Requires: bzip3
# Requires: cdrecord # for .iso support
Requires: dconf gnome-icon-theme

BuildRequires(pre): rpm-macros-meson rpm-build-gnome
BuildRequires: meson yelp-tools
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk4-devel >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: desktop-file-utils >= %desktop_file_utils_ver
BuildRequires: libjson-glib-devel libportal-devel libportal-gtk4-devel >= %portal_ver
%{?_enable_libarchive:BuildRequires: libarchive-devel >= %libarchive_ver}
%{?_enable_nautilus_actions:BuildRequires: libnautilus-devel >= 43}

%description
File Roller is an archive manager for the GNOME environment.  This means that
you can : create and modify archives; view the content of an archive; view a
file contained in the archive; extract files from the archive.
File Roller is only a front-end (a graphical interface) to archiving programs
like tar and zip. The supported file types are :
    * Tar archives uncompressed (.tar) or compressed with
          * gzip (.tar.gz, .tgz)
          * bzip (.tar.bz, .tbz)
          * bzip2 (.tar.bz2, .tbz2)
          * compress (.tar.Z, .taz)
          * lzop (.tar.lzo, .tzo)
    * Ar archives (.ar)
    * Arj archives (.arj)
    * Jar archives (.jar, .ear, .war)
    * Lha archives (.lzh)
    * Rar archives (.rar)
    * Zip archives (.zip)
    * 7-Zip archives (.7z)
    * Single files compressed with gzip, bzip, bzip2, compress, lzop

%description -l ru_RU.UTF-8
File Roller - архиватор для рабочего стола GNOME. С его помощью можно:
создавать архивы и изменять их содержимое, читать оглавление архивов,
просматривать и распаковывать заключенные в архив файлы.
File Roller является графической оболочкой к различным средствам сжатия
данных. В число поддерживаемых программой типов архивов входят:
    * Архивы Tar как несжатые (.tar), так и сжатые посредством
          * gzip (.tar.gz, .tgz)
          * bzip (.tar.bz, .tbz)
          * bzip2 (.tar.bz2, .tbz2)
          * compress (.tar.Z, .taz)
          * lzop (.tar.lzo, .tzo)
    * Ar архивы (.ar)
    * Arj архивы (.arj)
    * Jar архивы (.jar, .ear, .war)
    * Lha архивы (.lzh)
    * Rar архивы (.rar)
    * Zip архивы (.zip)
    * 7-Zip архивы (.7z)
    * Отдельные файлы сжатые при помощи gzip, bzip, bzip2, compress, lzop.

%prep
%setup -n %name-%version%beta
%patch1

rm -f data/%xdg_name.desktop{,.in}

%build
%meson \
    %{?_enable_packagekit:-Dpackagekit=true} \
    %{?_enable_libarchive:-Dlibarchive=enabled} \
    %{?_disable_nautilus_actions:-Dnautilus-actions=false} \
    -Dnotification=enabled \
    -Dcpio='/bin/cpio'
%nil
%meson_build

%install
%meson_install

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%dir %_libexecdir/%name
%_libexecdir/%name/*.sh
%_libexecdir/%name/rpm2cpio
%dir %_datadir/%name
%_datadir/%name/*
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/dbus-1/services/%{xdg_name1}1.service
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/apps/%{xdg_name}*.*
%config %_datadir/glib-2.0/schemas/*
%_datadir/metainfo/%xdg_name.appdata.xml
%{?_enable_nautilus_actions:%_libdir/nautilus/extensions-%nau_api_ver/*.so}
%doc AUTHORS NEWS README.md

%changelog
