%define _unpackaged_files_terminate_build 1

Name: filesystem
Version: 3.1
Release: alt1

Summary: The basic directory layout for a GNU/Linux system
License: ALT-Public-Domain
Group: System/Base

Source0: %name-dir.list
Source1: %name-link.list
Source2: %name-dir-64.list
Source3: %name-link-64.list
source4: %name-dir-x32.list
source5: %name-link-x32.list
# Traditional MCST paths:
Source6: %name-dir-e2k32.list
Source7: %name-link-e2k32.list
Source16: %name-arch-dir-i586.list
Source17: %name-arch-dir-x86_64.list

Requires(pre,postun): setup

Provides: /var/empty /var/lock/serial
Provides: /media /proc /run /selinux /srv /sys
Provides: /usr/share/wallpapers
Provides: /usr/share/icons/hicolor
# http://bugzilla.altlinux.org/12020
Provides: /dev/pts
Provides: /dev/shm

Conflicts: shadow-utils < 4.4

%description
This package is one of the basic packages that is installed on a
%distribution system.  Filesystem contains the basic directory layout
for a FHS-compatible GNU/Linux operating system, including the correct
permissions for the directories.

%prep
%setup -cT

%build
emit_list() {
	[ -r %_sourcedir/%name-arch-$1-$2.list ] || return 0
	cat %_sourcedir/%name-arch-$1-$2.list
}

{
	cat %_sourcedir/%name-link.list
%ifarch %ix86
	emit_list link i586
%endif
%ifarch x86_64
	emit_list link x86_64
%endif
%if "%_lib" == "lib64"
	cat %_sourcedir/%name-link-64.list
%endif
%ifarch x32
	cat %_sourcedir/%name-link-64.list
%endif
%ifarch x86_64 x32
	cat %_sourcedir/%name-link-x32.list
%endif
%ifarch %e2k
	cat %_sourcedir/%name-link-e2k32.list
%endif
} > link-t-s.list

{
	cat %_sourcedir/%name-dir.list
%ifarch %ix86
	emit_list dir i586
%endif
%ifarch x86_64
	emit_list dir x86_64
%endif
%if "%_lib" == "lib64"
	cat %_sourcedir/%name-dir-64.list
%endif
%ifarch x32
	cat %_sourcedir/%name-dir-64.list
%endif
%ifarch x86_64 x32
	cat %_sourcedir/%name-dir-x32.list
%endif
%ifarch %e2k
	cat %_sourcedir/%name-dir-e2k32.list
%endif
} > dir.list

{
	cat dir.list
	echo '%%defattr(-,root,root,-)'
	cut -d' ' -f1 < %_sourcedir/%name-link.list
%if "%_lib" == "lib64"
	cut -d' ' -f1 < %_sourcedir/%name-link-64.list
%endif
%ifarch x32
	cut -d' ' -f1 < %_sourcedir/%name-link-64.list
%endif
%ifarch x86_64 x32
	cut -d' ' -f1 < %_sourcedir/%name-link-x32.list
%endif
%ifarch %e2k
	cut -d' ' -f1 < %_sourcedir/%name-link-e2k32.list
%endif
} > list

%install
mkdir %buildroot

while read attr dir name extra; do
	mkdir "%buildroot$name"
done < dir.list

while read source target; do
	ln -s "$target" "%buildroot$source"
done < link-t-s.list

%files -f list

%pretrans -p <lua>
migrate = false
if posix.stat("/usr") then
  -- See if we need to migrate to merged-usr.
  for i, d in pairs({
"/bin",
"/sbin",
"/lib",
%if "%_lib" == "lib64"
"/lib64",
%endif
%ifarch x32
"/lib64",
%endif
%ifarch x86_64 x32
"/libx32",
%endif
%ifarch e2k32
"/lib32",
%endif
}) do
    local dt = posix.stat(d, "type")
    if dt == "directory" then
      migrate = true
    end
  end
end

if migrate then
  -- We cannot use built-in print in case standard output
  -- is not line-buffered, e. g. points to a file.
  -- We know the shell is available at this point, so use it
  -- to print log lines.
  function print_l(s)
    os.execute('printf "%%s: %%s\n" "%name-%EVR" "' .. s .. '"')
  end
  print_l("Migration is needed before the package can be installed.")
  hier_convert_prog = "/usr/libexec/usrmerge/hier-convert"
  if not posix.stat(hier_convert_prog) then
    error("Looks like usrmerge-hier-convert is not installed. Aborting.")
  end
  print_l("Starting usrmerge-hier-convert...")
  assert(os.execute(hier_convert_prog))
end

%changelog
