Name: finger
Version: 1.3
Release: alt3

Summary: Show user information (client)
License: BSD
Group: Networking/Other
Url: https://build.opensuse.org/package/show/openSUSE:Factory/finger

Source: finger-bsd-%version.tar
Source1: %name.xinetd

# These patches were taken from the:
# https://build.opensuse.org/package/show/openSUSE:Factory/finger
Patch1: finger-memory-leak.patch
Patch2: finger-utf8_segfault.patch
Patch3: finger-no-common.patch

%package server
Summary: A Server for Showing User Information
Group: System/Servers

%description
Finger is a utility that allows users to see information about system
users (login name, home directory, name, and more), on local and remote
systems. The %name package includes a standard finger client.

%description server
Finger is a utility that allows users to see information about system
users (login name, home directory, name, and more), on local and remote
systems. The %name-server package includes a standard finger server.
The server daemon (%{name}d) usually runs from %_sysconfdir/xinetd.d/%name.

You should install %name-server if your system is used by multiple users
and you'd like finger information to be available.

%prep
%setup -q -n finger-bsd-%version
%patch1 -p1
%patch2 -p0
%patch3 -p1

%build
export CFLAGS=-fno-common
%configure
%make_build

%install
install -D -m640 %SOURCE1 $RPM_BUILD_ROOT%_sysconfdir/xinetd.d/%name
%makeinstall

%find_lang finger-bsd

%files -f finger-bsd.lang
%attr(711,root,root) %_bindir/*
%_man1dir/*

%files server
%config(noreplace) %_sysconfdir/xinetd.d/%name
%attr(711,root,root) %_sbindir/*
%_man8dir/*

%changelog
