%def_disable snapshot
%define _libexecdir %_prefix/libexec

%define rdn_name com.github.FontManager.FontManager
%define rdn_name1 com.github.FontManager.FontViewer

%def_enable nautilus
%define nautilus_extdir %_libdir/nautilus/extensions-4

Name: font-manager
Version: 0.9.2
Release: alt1

Summary: A font management application for the GNOME desktop
License: GPL-3.0-or-later
Group: Graphical desktop/GNOME
Url: https://fontmanager.github.io/

Vcs: https://github.com/FontManager/font-manager.git

%if_disabled snapshot
Source: https://github.com/FontManager/%name/archive/%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

Requires: file-roller yelp

%define vala_ver 0.42
%define pango_ver 1.4
%define adw_ver 1.5

BuildRequires(pre): meson rpm-build-gir
BuildRequires: vala-tools >= %vala_ver
BuildRequires: libpango-devel >= %pango_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: libjson-glib-devel
BuildRequires: libsqlite3-devel libxml2-devel
BuildRequires: yelp-tools desktop-file-utils /usr/bin/appstream-util
BuildRequires: gobject-introspection-devel libjson-glib-gir-devel gir(Adw) = 1
BuildRequires: pkgconfig(webkitgtk-6.0)
%{?_enable_nautilus:BuildRequires: libnautilus-devel}

%description
Font Manager is an application that allows users to easily manage fonts
on their system.

Font Manager is not intended to be a professional-grade font management
solution, but rather a simple application suitable for the needs of most
desktop users, and even graphics designers who may need to manage just a
few thousand font files.

Although designed with the GNOME desktop environment in mind, it should
work well with most major desktop environments such as XFCE,
Enlightenment, and even KDE.

%prep
%setup

%build
%meson \
    -Dreproducible=true \
    %{subst_enable_meson_bool nautilus nautilus}
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%dir %_libexecdir/%name
%_libexecdir/%name/font-viewer
%_libdir/%name/
%_desktopdir/%rdn_name.desktop
%_desktopdir/%rdn_name1.desktop
%_datadir/dbus-1/services/%rdn_name.service
%_datadir/dbus-1/services/%rdn_name1.service
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_datadir/glib-2.0/schemas/%rdn_name1.gschema.xml
%_iconsdir/hicolor/*/apps/*.svg
%_datadir/gnome-shell/search-providers/%rdn_name.SearchProvider.ini
%_man1dir/%name.1.*
%_datadir/metainfo/%rdn_name.metainfo.xml
%_datadir/metainfo/%rdn_name1.metainfo.xml
%{?_enable_nautilus:%nautilus_extdir/*.so}
%doc README* CHANGELOG


%changelog
