%define _unpackaged_files_terminate_build 1

Name: forgejo-runner
Version: 11.3.1
Release: alt1

%global import_path code.forgejo.org/forgejo/runner/v%(echo %{version} | cut -d. -f1)

Summary: Forgejo Runner
License: GPLv3-or-later
Group: Other
Url: https://forgejo.org/docs/latest/admin/actions/#forgejo-runner
Vcs: https://code.forgejo.org/forgejo/runner.git

Source: %name-%version.tar
Source2: %name.service
Source3: README-alt.md
Patch: %name-%version.patch

ExclusiveArch: %go_arches

BuildRequires(pre): rpm-macros-systemd rpm-macros-golang
BuildRequires: rpm-build-golang golang >= 1.24.7

#Requires: docker-engine
Requires: sysctl-conf-userns podman systemd-container

%description
A runner for Forgejo Actions.

%prep
%setup
%autopatch -p1

%build
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"
export GOFLAGS="-mod=vendor"
export LDFLAGS="-X %import_path/internal/pkg/ver.version=v%version"
export GOPATH="$BUILDDIR:%go_path"

%golang_prepare

%golang_build .

%install
cp %SOURCE3 ./
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"
export IGNORE_SOURCES=1
mkdir -p %buildroot{%_bindir,%_userunitdir,%_sysconfdir/%name,%_sharedstatedir/%name}

%golang_install

mv %buildroot%_bindir/runner %buildroot%_bindir/%name

%buildroot%_bindir/%name generate-config > %buildroot%_sysconfdir/%name/config.yaml

install -m 0644 %SOURCE2 %buildroot%_userunitdir/%name.service

%pre
groupadd -r -f _%name > /dev/null 2>&1 ||:
useradd -r -g _%name -s /dev/null -c "%name services" -M -d %_sharedstatedir/%name _%name > /dev/null 2>&1 ||:
#usermod -aG docker _%name

%post
%systemd_user_post %name.service
# First install
if [ $1 -ge 1 ] &&  sd_booted; then
#Configure rootless podman for user _%name
# 1. sysctl kernel.unprivileged_userns_clone=1
# depend on sysctl-conf-userns package
# 2. Allow newgidmap and newgidmap for user
  control newgidmap public
  control newuidmap public
# 3. Add subuid and subgid
  usermod --add-subuids 100000-165536 --add-subgids 100000-165536 _%name
# 4. Allow autostart user units
  loginctl enable-linger _%name
# 5. Enable user units
  user_id=$(id -u _%name)
  SYSTEMCTL=systemctl
  $SYSTEMCTL --user -M "$user_id@" enable podman.socket
  $SYSTEMCTL --user -M "$user_id@" enable %name.service
fi
exit 0

%preun
%systemd_user_preun %name.service

%postun
%systemd_user_postun_with_restart %name.service

%files
%doc README.md LICENSE RELEASE-NOTES.md README-alt.md
%attr(0770,root,_%name) %dir %_sysconfdir/%name
%attr(0640,root,_%name) %config(noreplace) %_sysconfdir/%name/config.yaml
%attr(0770,root,_%name) %dir %_sharedstatedir/%name
%_bindir/%name
%_userunitdir/%name.service

%changelog
