Name: freedroidrpg
Version: 0.16.1
Release: alt3

Summary: Isometric action game with RPG elements
License: GPLv2
Group: Games/Arcade
Url: http://freedroid.sf.net
Packager: Roman Savochenko <rom_as at altlinux.ru>

BuildRequires(pre): rpm-build-python3
BuildPreReq: libSDL-devel libGLU-devel libjpeg-devel zlib-devel libpng-devel libSDL_image-devel libSDL_net-devel libvorbis-devel libSDL_mixer-devel libSDL_gfx-devel

Requires: %name-data = %version

Source: %name-%version.tar.bz2
Source1: %name.desktop
Source3: %name-16x16.png
Source4: %name-32x32.png
Source5: %name-48x48.png

# Fix multiple definitions
Patch: e610d427374226b79da5258d979936459f30c761.patch

%description
Interesting Diablo-like game featuring The Tux as the main character.

%package tools
Group: Games/Arcade
Summary: Some edit tools for Freedroid RPG
Requires: %name = %version-%release
%description tools
This package contains some edit tools required to
develop new content to the Freedroid RPG game. 

%package data
Group: Games/Arcade
Summary: Media files Freedroid RPG
BuildArch: noarch

%description data
This package contains media files for Freedroid RPG game

%prep
%setup
%patch -p1

# see https://gitlab.com/freedroid/freedroid-src/-/commit/642f6a95ad4fa8211abf68327685caaf20d46e7d.patch
sed -i 's/\(strncpy(MenuTexts\[i\], \)Options\[i\]/\1\&(Options\[i\]\[0\])/' src/menu.c

sed -i 's|#!.*python|&3|' $(find ./ -name '*.py')

%build
%configure --datadir=%_gamesdatadir --bindir=%_gamesbindir --enable-dev-tools
%make_build

%install
%make_install DESTDIR=%buildroot install
%find_lang %name %name-data %name-dialogs --output=%name.lang

#install desktop file
mkdir -p %buildroot%_desktopdir
cp %SOURCE1 %buildroot%_desktopdir/

#install icons
install -D %SOURCE3 %buildroot%_miconsdir/%name.png
install -D %SOURCE4 %buildroot%_niconsdir/%name.png
install -D %SOURCE5 %buildroot%_liconsdir/%name.png

#install appdata
mv %buildroot%_gamesdatadir/appdata %buildroot%_datadir

%files -f %name.lang
%_gamesbindir/freedroidRPG
%_desktopdir/%name.desktop
%_liconsdir/%name.png
%_miconsdir/%name.png
%_niconsdir/%name.png

%files data
%doc AUTHORS ChangeLog NEWS README* INSTALL HELP_WANTED
%_gamesdatadir/%name
%_datadir/appdata/*
%_man6dir/*
%exclude %_gamesdatadir/icons
%exclude %_gamesdatadir/applications
%exclude %_datadir/doc/%name

%files tools
%_gamesbindir/croppy
#%%_gamesbindir/pngtoico
%_gamesbindir/explode_atlas
%_gamesbindir/explodefont
%_gamesbindir/gluefont
%_gamesbindir/make_atlas

%changelog
