%define _unpackaged_files_terminate_build 1
%def_with opencv

Name: frei0r-plugins
Version: 2.3.3
Release: alt1

Summary: A free software collection of video effect plugins
License: GPL-2.0-or-later
Group: Video
Url: https://frei0r.dyne.org
Vcs: https://github.com/dyne/frei0r.git

Source: %name-%version.tar

BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: doxygen
BuildRequires: libcairo-devel
%{?_with_opencv:BuildRequires: libopencv-devel}

%description
The frei0r project is a collection of free and open
source video effects plugins that can be used with
a variety of video editing and processing software.

%package -n frei0r-devel
Summary: Development files for %name
Group: Development/C

%description -n frei0r-devel
Frei0r - a minimalistic plugin API for video effects.

%package -n frei0r-devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch

%description -n frei0r-devel-doc
This package contains development documentation for %name.

%if_with opencv
%package opencv
Summary: Frei0r plugins using OpenCV
Group: Video
Requires: libopencv-utils

%description opencv
Frei0r plugins that use the OpenCV computer vision framework.
%endif

%prep
%setup

%build
%cmake \
	%{?_without_opencv:-DWITHOUT_OPENCV:BOOL=ON} \
	%nil
%cmake_build

pushd doc
doxygen Doxyfile
popd

%install
%cmake_install

%files
%dir %_libdir/frei0r-1
%_libdir/frei0r-1/*.so
%if_with opencv
%exclude %_libdir/frei0r-1/facebl0r.so
%exclude %_libdir/frei0r-1/facedetect.so
%endif

%files -n frei0r-devel
%_includedir/frei0r.h
%_pkgconfigdir/frei0r.pc

%files -n frei0r-devel-doc
%doc doc/html

%if_with opencv
%files opencv
%dir %_libdir/frei0r-1
%_libdir/frei0r-1/facebl0r.so
%_libdir/frei0r-1/facedetect.so
%endif

%changelog
