%global appid org.gajim.Gajim

# reduce an amount of overabundant dependencies
%filter_from_requires /^python3(gajim.gui/d

Name: gajim
Version: 1.8.4
Release: alt2

Summary: a Jabber client written in PyGTK
License: GPL-3.0-only
Group: Networking/Instant messaging
Url: http://gajim.org
Packager: Ilya Mashkin <oddity@altlinux.ru>

Source: https://gajim.org/downloads/1.3/gajim-%version.tar.gz
Patch1: gajim-1.2.2-alt-fix-egg-requires.patch

# https://gajim.org/post/2023-01-07-gajim-1.6.0-released/
Requires: python3 >= 3.10

# typelib(Avahi)
%filter_from_requires /^typelib(Avahi)/d
# typelib(AppIndicator3)
%filter_from_requires /^typelib(AppIndicator3)/d

Requires: libgtk+3-gir libgtksourceview4-gir
Requires: python3-module-nbxmpp >= 4.5.3
Requires: typelib(AyatanaAppIndicator3)
# gajim >= 1.8 has imcoropated OMEMO support
Obsoletes: gajim-plugin-omemo <= 2.9.0-alt1 python3-module-gajim-omemo <= 2.9.0-alt1
%py3_requires cssutils
%py3_requires keyring
%py3_requires precis_i18n
%py3_requires nbxmpp
%py3_requires precis_i18n
%py3_requires OpenSSL
%py3_requires cairo

%add_python3_req_skip winsdk.windows.ui winsdk.windows.ui.viewmanagement

%ifarch %e2k
BuildRequires: librpmconstant-devel
Requires: librpmconstant0
%endif


BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: libgtk+3-devel python3-devel python3-module-setuptools libsoup-gir-devel libgtksourceview4-gir-devel pyproject-build rpm-macros-python3 python3-module-build
BuildRequires: python3-module-nbxmpp >= 4.5.3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildArch: noarch

%description
Gajim is a Jabber client written in PyGTK. The goal of Gajim's developers
is to provide a full featured and easy to use xmpp client for the GTK+
users. Gajim does not require GNOME to run, eventhough it exists with
it nicely.

%prep
%setup -n %name-%version
#patch1 -p1

%build
%pyproject_build 
#python3_build
./pep517build/build_metadata.py -o dist/metadata

%install
%pyproject_install
#python3_install
./pep517build/install_metadata.py dist/metadata --prefix=%{buildroot}%{_prefix}

mkdir -p %{buildroot}%{_datadir}/
mv %{buildroot}{%{python3_sitelibdir}/%{name}/data,%{_datadir}/%{name}}/
ln -s %{_datadir}/%{name} %{buildroot}%{python3_sitelibdir}/%{name}/data

# Move locales to the system path.
mv %{buildroot}%{_datadir}/{%{name}/locale,locale}/
ln -s %{_datadir}/locale %{buildroot}%{_datadir}/%{name}/locale
# The plugins subdirectory must be owned by the package.
mkdir %{buildroot}%{_datadir}/%{name}/plugins/


%find_lang %name

%pretrans -p <lua>
-- see http://git.altlinux.org/gears/e/example-pretrans-dir-to-symlink.git
-- Define the path to directory being replaced below.
-- DO NOT add a trailing slash at the end.
path = "%python3_sitelibdir/%name/data"
st = posix.stat(path)
if st and st.type == "directory" then
  status = os.rename(path, path .. ".rpmmoved")
  if not status then
    suffix = 0
    while not status do
      suffix = suffix + 1
      status = os.rename(path .. ".rpmmoved", path .. ".rpmmoved." .. suffix)
    end
    os.rename(path, path .. ".rpmmoved")
  end
end

%files -f %name.lang
#doc AUTHORS ChangeLog README THANKS
%_bindir/%name
%_bindir/%name-remote
#_bindir/%name-history-manager
%_man1dir/*
%_datadir/applications/%appid.desktop
%_datadir/metainfo/%appid.appdata.xml
%_datadir/icons/hicolor/scalable/apps/%appid.svg
%_datadir/icons/hicolor/scalable/apps/%appid-symbolic.svg
%python3_sitelibdir/%name
%python3_sitelibdir/%name-%{version}*.dist-info
%_datadir/%name/sounds/*
%_datadir/%name/style/*
%_datadir/%name/icons/hicolor/*/*/*
%_datadir/%name/other/*
%_datadir/%name/gui/*


%changelog
