%def_enable snapshot

%define ver_major 48
%define beta %nil
# removed python plugins since 48.2
%def_disable python
# removed since 3.36
%def_disable zeitgeist
%define gedit_pluginsdir %_libdir/gedit/plugins
%{?_enable_python:%add_python3_path %gedit_pluginsdir}

Name: gedit-plugins
Version: %ver_major.2
Release: alt1%beta

Summary: Plugins for GEdit
License: GPL-2.0
Group: Editors
Url: https://gedit-technology.github.io

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.40.0
%define gtk_ver 3.24
%define gtksourceview_ver 299.0.4
%define gedit_ver 48.0
%define peas_ver 1.14.1
%define git2_ver 0.0.12
%define vte_ver 0.38

Requires: gedit >= %ver_major
%{?_enable_python:Requires: libpeas-python3-loader
Requires: libvte3-gir >= %vte_ver}
%{?_enable_zeitgeist:Requires: zeitgeist}

BuildRequires(pre): rpm-macros-meson rpm-build-gir rpm-build-gnome
BuildRequires: meson gnome-common libappstream-glib-devel
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libgedit-gtksourceview-devel >= %gtksourceview_ver
BuildRequires: gedit-devel >= %gedit_ver
BuildRequires: libpeas-devel >= %peas_ver
BuildRequires: yelp-tools
# for git plugin
BuildRequires: libgit2-glib-devel >= %git2_ver
# for Charmap plugin
BuildRequires: libgucharmap-devel >= 3.0.0 libgucharmap-gir-devel
%{?_enable_zeitgeist:BuildRequires: libzeitgeist2.0-devel libzeitgeist2.0-gir-devel}
%if_enabled python
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-pygobject3-devel
%endif
BuildRequires: libxml2-devel python3-module-dbus-devel libvte3-gir-devel

%description
gEdit is a small but powerful text editor designed expressly for GNOME.

It includes such features as split-screen mode, a plugin API, which
allows gEdit to be extended to support many features while remaining
small at its core, multiple document editing through the use of a
'tabbed' notebook and many more functions.

This package contains various plugins for gEdit.

%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang gedit %name

%files -f %name.lang
%{?_enable_python:%dir %_datadir/gedit/plugins
%_datadir/gedit/plugins/*}
%gedit_pluginsdir/*
%config %_datadir/glib-2.0/schemas/org.gnome.gedit.plugins.drawspaces.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gedit.plugins.wordcompletion.gschema.xml
%{?_enable_python:%config %_datadir/glib-2.0/schemas/org.gnome.gedit.plugins.terminal.gschema.xml}
#%config %_datadir/glib-2.0/schemas/org.gnome.gedit.plugins.translate.gschema.xml
%_datadir/metainfo/gedit-*.metainfo.xml


%changelog
