Name: getdp
Version: 3.5.0
Release: alt2

Summary: A General Environment for the Treatment of Discrete Problems
License: GPLv2
Group: Sciences/Mathematics

Url: https://getdp.info
Source: %name-%version.tar

BuildPreReq: rpm-macros-cmake
BuildRequires: cmake gcc-c++ gcc-fortran
BuildRequires: libopenblas-devel liblapack-devel
BuildRequires: libarpack-ng-devel libgsl-devel
BuildRequires: libsparskit-devel
BuildRequires: libgmsh-devel

%description
GetDP is a free finite element solver using mixed elements to discretize
de Rham-type complexes in one, two and three dimensions.

%prep
%setup
%ifarch %e2k
# libgfortran is not linked against libquadmath as of lcc 1.26.16;
# looks like that's not uncommon on x86 either
sed -i 's,-lgfortran,& -lquadmath,' CMakeLists.txt
%endif

%build
# - For linking with gmsh it should be build with private API enabled.
# - In Altlinux autodetection does not work correctly for
#   libopenblas + liblapack, BLAS_LAPACK_LIBRARIES should be set.
%cmake_insource -DENABLE_PETSC=0 -DENABLE_SPARSKIT=1 \
                -DENABLE_GMSH=1 \
                -DBLAS_LAPACK_LIBRARIES="-lopenblas -llapack"

%make_build VERBOSE=1

%install
%makeinstall_std

%files
%_bindir/getdp
%dir %_docdir/getdp
%_docdir/getdp/*
%_man1dir/getdp.*

%changelog
