%define _libexecdir %_prefix/libexec

%ifnarch %ix86 x86_64
%define optflags_lto %nil
%endif

%define ver_major 3.0
%define oldver 3.0

%define mypaint_ver 1.3
%define brushes_ver 1.0

Name: gimp
Version: %ver_major.2
Release: alt1

Summary: The GNU Image Manipulation Program
License: %gpl3only
Group: Graphics
Url: http://www.gimp.org/

Packager: Valery Inozemtsev <shrek@altlinux.ru>

Obsoletes: gimp2 < %version-%release
Provides: gimp2 = %version-%release
Conflicts: gimp2-perl create-resources <= 0.1.3-alt1
Requires: lib%name = %version-%release
Requires: iso-codes icc-profiles mypaint-brushes%brushes_ver

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildPreReq: rpm-build-licenses rpm-build-python3
BuildRequires: bzlib-devel gcc-c++ gtk-doc intltool libXcursor-devel libXfixes-devel libXmu-devel libXpm-devel libalsa-devel libappstream-glib-devel
BuildRequires: libarchive-devel libexpat-devel libgexiv2-devel libgs-devel libgtk+3-gir-devel libgudev-devel libheif-devel liblcms2-devel liblzma-devel
BuildRequires: libmng-devel libmypaint-devel libopenjpeg2.0-devel libpoppler-glib-devel librsvg-devel libtiff-devel libwebkit2gtk-devel libwebp-devel
BuildRequires: libjxl-devel libwmf-devel openexr-devel python3-module-pygobject3 vala-tools xdg-utils meson cmake iso-codes-devel libbabl-devel libgegl-devel
BuildRequires: libbabl-gir libgegl-gir libexiv2-devel mypaint-brushes%brushes_ver-devel

%description
The GIMP (GNU Image Manipulation Program) is a powerful image
composition and editing program, which can be extremely useful for
creating logos and other graphics for Web pages.  The GIMP has many of
the tools and filters you would expect to find in similar commercial
offerings, and some interesting extras as well. The GIMP provides a
large image manipulation toolbox, including channel operations and
layers, effects, sub-pixel imaging and anti-aliasing, and conversions,
all with multi-level undo.

%package -n lib%name
Summary: GIMP libraries
Group: System/Libraries
License: %lgpl3only
Obsoletes: libgimp2 < %version-%release
Provides: libgimp2 = %version-%release

%description -n lib%name
Libraries used to communicate between The GIMP and other programs which
may function as "GIMP plugins".

%package -n lib%name-devel
Summary: GIMP plugin and extension development kit
Group: Graphics
Obsoletes: libgimp2-devel < %version-%release
Provides: libgimp2-devel = %version-%release

%description -n lib%name-devel
Development libraries and header files for writing GIMP plugins and extensions.

%add_python3_path %_libdir/%name/%oldver/plug-ins

%prep
%setup -q
%patch -p1

tar -xf gimp-data.tar.xz
%ifnarch ix86
sed 's|lib/gir|lib64/gir|' -i data/environ/python.env app/main.c
%endif

%build
%meson \
	-Dgimpdir=%name \
	-Dlua=false \
	-Djavascript=disabled \
	-Denable-console-bin=true \
	-Dcheck-update=no

%meson_build -v

%install
%meson_install

rm -fr %buildroot%_libdir/%name/%oldver/extensions/org.gimp.extension.goat-exercises
find %buildroot%_libdir/%name -name \*.la -delete

# Execute find_lang for all components and merge the resulting lists
%find_lang --output=global.lang gimp30 gimp30-libgimp gimp30-std-plug-ins gimp30-script-fu gimp30-tips gimp30-python

%files -f global.lang
%doc AUTHORS NEWS README README.i18n
%dir %_sysconfdir/%name
%dir %_sysconfdir/%name/%oldver
%config %_sysconfdir/%name/%oldver/*
%_bindir/%name-console-*
%_bindir/%name-*
%_libdir/%name
%_typelibdir/*.typelib
%_datadir/%name
%_datadir/metainfo/*.xml
%_iconsdir/hicolor/*/apps/*
%_desktopdir/%name.desktop
%_man1dir/*
%_man5dir/*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
#%_datadir/gtk-doc/html/*
%_includedir/*
%_bindir/gimptool-*
%_libexecdir/gimp-debug-tool-*
%_libdir/*.so
%_girdir/*
%_vapidir/*
%_pkgconfigdir/*.pc

%changelog
