Name: git-cola
Version: 4.13.0
Release: alt1

Summary: A highly caffeinated git gui
License: GPL-2.0-or-later
Group: Development/Tools

Url: https://git-cola.github.io
Vcs: git://github.com/git-cola/git-cola.git
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-sphinx-devel python3-module-setuptools python3-module-wheel python3-module-qtpy python3-module-PyQt5 rsync
# hasher tests:
Requires: python3-module-pyinotify python3-module-PyQt5 git-core

%description
A sweet, carbonated git gui known for its sugary flavour
and caffeine-inspired features.

%package -n bash-completion-%name
Summary: Bash completion for %name
Group: Shells
BuildArch: noarch

%description -n bash-completion-%name
The official bash completion script for %name.

%package -n zsh-completion-%name
Summary: Zsh completion for %name
Group: Shells
BuildArch: noarch

%description -n zsh-completion-%name
The official zsh completion script for %name.

%prep
%setup
%prepare_sphinx3 share/doc/%name
sed -i '/Git Cola version/s/%%(cola_version)s/%{version}/' \
  cola/widgets/about.py
sed -i '/prefix =/s|\$(HOME)|%_prefix|' Makefile

%build
%pyproject_build
%make_build doc man
%ifnarch aarch64 ppc64le
%make_build html
%endif

%install
export DESTDIR=%buildroot
%pyproject_install
%make_install \
  install-desktop-files \
  install-icons \
  install-htmldocs \
  install-metainfo \
  install-doc \
%ifnarch aarch64 ppc64le
  install-html \
%endif
  install-man

# zsh and bash
install -Dm644 contrib/_%{name} -t %buildroot%_datadir/zsh/site-functions/
install -Dm644 contrib/%name-completion.bash %buildroot%_datadir/bash-completion/completions/%name

# executable script is not executable
chmod +x %buildroot%python3_sitelibdir/cola/bin/ssh-askpass
chmod +x %buildroot%python3_sitelibdir/cola/bin/ssh-askpass-darwin

%find_lang %name

%files -f %name.lang
%doc CHANGES.rst CONTRIBUTING.md LICENSE README.md
%_bindir/*
%_desktopdir/*.desktop
%_docdir/git-cola
%_iconsdir/hicolor/scalable/apps/git-cola.svg
%_datadir/metainfo/git-*.appdata.xml
%_man1dir/git-*.1.xz
%python3_sitelibdir/*

%files -n bash-completion-%name
%_datadir/bash-completion/completions/%name

%files -n zsh-completion-%name
%_datadir/zsh/site-functions/_%{name}

%changelog
