%def_disable snapshot

%define xdg_name org.gnome.Calendar
%define ver_major 48
%define beta %nil
%define _libexecdir %_prefix/libexec

%def_disable gtk_doc

Name: gnome-calendar
Version: %ver_major.1
Release: alt1%beta

Summary: Calendar application for GNOME
License: GPL-3.0-or-later
Group: Graphical desktop/GNOME
Url: https://apps.gnome.org/Calendar

Vcs: https://gitlab.gnome.org/GNOME/gnome-calendar.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define glib_ver 2.68.0
%define gtk4_ver 4.18
%define adwaita_ver 1.7
%define ical_ver 1.0.1
%define eds_ver 3.46
%define gsds_ver 3.21.2
%define gweather_ver 3.99
%define geocode_ver 3.26.3

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson yelp-tools /usr/bin/appstreamcli
BuildRequires: libgio-devel >= %glib_ver libgtk4-devel >= %gtk4_ver
BuildRequires: libical-devel >= %ical_ver libicu-devel
BuildRequires: libgnome-online-accounts-devel vala-tools
BuildRequires: gobject-introspection-devel
BuildRequires: evolution-data-server-devel >= %eds_ver
BuildRequires: gsettings-desktop-schemas-devel >= %gsds_ver
BuildRequires: libgweather4.0-devel >= %gweather_ver
BuildRequires: pkgconfig(libgeoclue-2.0) pkgconfig(geocode-glib-2.0) >= %geocode_ver
BuildRequires: libsoup3.0-devel
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver
%{?_enable_gtk_doc:BuildRequires: gtk-doc}

%description
Calendar is a calendar application for GNOME.

%package devel-doc
Summary: Development documentation for GNOME Calendar
Group: Development/GNOME and GTK+
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package provides Calendar reference manual.


%prep
%setup -n %name-%version%beta

%build
%meson -Dprofile=default
%nil
%meson_build

%install
%meson_install

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/gnome-shell/search-providers/%xdg_name.search-provider.ini
%_desktopdir/%xdg_name.desktop
#%_man1dir/*
%_datadir/glib-2.0/schemas/org.gnome.calendar.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.calendar.enums.xml
%_iconsdir/hicolor/scalable/apps/*.svg
%_iconsdir/hicolor/symbolic/apps/*.svg
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc NEWS README.md

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/%name
%endif

%changelog
