%def_disable snapshot

%define ver_major 48
%define beta %nil
%define _libexecdir %_prefix/libexec
%define gst_api_ver 1.0
%define xdg_name org.gnome.Contacts
%def_enable check

Name: gnome-contacts
Version: %ver_major.0
Release: alt1%beta

Summary: Contacts manager for GNOME
License: GPL-2.0-or-later
Group: Graphical desktop/GNOME
Url: https://apps.gnome.org/Contacts

Vcs: https://gitlab.gnome.org/GNOME/gnome-contacts.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define glib_ver 2.64
%define gtk4_ver 4.15.3
%define adwaita_ver 1.6
%define vala_ver 0.56.11
%define folks_ver 0.15.6
%define eds_ver 3.42
%define portal_ver 0.6
%define libqrencode_ver 4.1.1

Requires: gst-plugins-base1.0
Requires: gst-plugin-gtk4

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson vala-tools
BuildRequires: yelp-tools xsltproc docbook-dtds docbook-style-xsl valadoc
BuildRequires: libgio-devel >= %glib_ver libgtk4-devel >= %gtk4_ver pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: libfolks-devel >= %folks_ver libfolks-vala libvala-devel >= %vala_ver
BuildRequires: libgnome-online-accounts-devel libgee0.8-devel evolution-data-server-devel >= %eds_ver
BuildRequires: gobject-introspection-devel
BuildRequires: libportal-gtk4-devel >= %portal_ver
BuildRequires: libqrencode-devel >= %libqrencode_ver
BuildRequires: pkgconfig(gstreamer-1.0)
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils}

%description
%name is a standalone contacts manager for GNOME desktop.

%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang %name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_libexecdir/%name-search-provider
%dir %_libexecdir/%name
%_libexecdir/%name/%name-parser
%_datadir/applications/%xdg_name.desktop
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/dbus-1/services/%xdg_name.SearchProvider.service
%_datadir/gnome-shell/search-providers/%xdg_name.search-provider.ini
%_iconsdir/hicolor/*/*/*
%_man1dir/%name.1.*
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc README*

%changelog
