%def_enable snapshot
%define ver_major 41
%define beta .alpha
%define xdg_name org.gnome.Dictionary.Devel
%define api_ver 1.0

%def_enable man

Name: gnome-dictionary
Version: %ver_major
Release: alt0.5%beta

Summary: Gnome client for MIT dictionary server
Group: Graphical desktop/GNOME
License: LGPLv2.1
Url: https://wiki.gnome.org/Apps/Dictionary

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

Obsoletes: libgdict < %version

%define glib_ver 2.42.0
%define gtk_ver 3.22.7

BuildRequires(pre): rpm-macros-meson rpm-build-gnome
BuildRequires: meson libappstream-glib-devel desktop-file-utils yelp-tools
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver
%{?_enable_man:BuildRequires: xsltproc docbook-dtds docbook-style-xsl}

%description
GNOME Dictionary - look up an online dictionary for definitions and
correct spelling of words.

%prep
%setup -n %name-%version%beta

%build
%meson -Duse_ipv6=true \
    %{?_disable_man:-Dbuild_man=false}
%nil
%meson_build

%install
%meson_install

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_desktopdir/%xdg_name.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/org.gnome.dictionary.gschema.xml
%_datadir/gdict-%api_ver/
%_iconsdir/hicolor/*/apps/*.svg
%_datadir/metainfo/%xdg_name.appdata.xml
%{?_enable_man:%_man1dir/%name.*}
%doc NEWS README*

%changelog
