%def_disable snapshot
%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec

%define _name swell-foop
%define ver_major 48
%define beta %nil
%define xdg_name org.gnome.SwellFoop

%def_enable check

Name: gnome-games-%_name
Version: %ver_major.1
Release: alt1%beta

Summary: The "Same Game" puzzle
Group: Games/Boards
License: GPL-3.0-or-later
Url: https://wiki.gnome.org/Apps/Swell-Foop

Vcs: https://gitlab.gnome.org/GNOME/swell-foop.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version%beta.tar.xz
%else
Source: %_name-%version%beta.tar
%endif

Provides:  %_name = %EVR

%define glib_ver 2.78.0
%define gtk_ver 4.10
%define adw_ver 1.5

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson vala-tools yelp-tools
BuildRequires: libgio-devel >= %glib_ver libgtk4-devel >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: pkgconfig(librsvg-2.0)
BuildRequires: pkgconfig(libgnome-games-support-2)
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils}

%description
The objective of same-gnome is to remove as many balls from the playing
area in as few moves as possible.

%prep
%setup -n %_name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %_name

%check
%__meson_test

%files -f %_name.lang
%_bindir/%_name
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*x*/apps/%xdg_name.png
%_iconsdir/hicolor/symbolic/apps/%xdg_name-symbolic.svg
%_datadir/dbus-1/services/%xdg_name.service
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.metainfo.xml

%changelog
