%def_disable snapshot
%define _userunitdir %(pkg-config systemd --variable systemduserunitdir)

%define ver_major 48
%define beta %nil
%define _libexecdir %_prefix/libexec
%def_enable session_selector
%def_enable docs
%def_enable man
%def_enable x11

Name: gnome-session
Version: %ver_major.0
Release: alt1%beta

Summary: The gnome session programs for the GNOME GUI desktop environment
Group: Graphical desktop/GNOME
License: GPL-2.0-or-later
Url: https://wiki.gnome.org/Projects/SessionManagement

Vcs: https://gitlab.gnome.org/GNOME/gnome-session.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif
Source1: gnome.svg

# https://bugzilla.gnome.org/show_bug.cgi?id=775463
Patch: %name-2.91.6-alt-autosave_session.patch

# fedora patches:
# Blacklist NV30: https://bugzilla.redhat.com/show_bug.cgi?id=745202
Patch11: gnome-session-3.3.92-nv30.patch

# From configure.ac
%define glib_ver 2.46.0
%define gtk_ver 3.22.0
%define polkit_ver 0.91
%define upower_ver 0.9
%define systemd_ver 242

Requires(pre): libcanberra-gnome libcanberra-gtk3
Requires: altlinux-freedesktop-menu-gnome3
Requires: dbus-tools-gui
Requires: gnome-filesystem
Requires: upower gcr gcr4
Requires: xdg-user-dirs

Requires: icon-theme-hicolor gnome-icon-theme-symbolic gnome-themes-standard

BuildRequires(pre): rpm-macros-meson rpm-build-gnome rpm-build-systemd
BuildRequires: meson
BuildRequires: libgio-devel glib2-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libgnome-desktop3-devel libjson-glib-devel
BuildRequires: perl-XML-Parser xmlto docbook-utils
BuildRequires: pkgconfig(systemd) >= %systemd_ver
%{?_enable_x11:BuildRequires: pkgconfig(x11) pkgconfig(sm) pkgconfig(ice)
BuildRequires: pkgconfig(xtrans) pkgconfig(xcomposite)}
%{?_enable_docs:BuildRequires: docbook-utils xmlto}
%{?_enable_man:BuildRequires: docbook-utils docbook-style-xsl xsltproc}
# since 3.22.2
BuildRequires: libepoxy-devel

%description
GNOME (GNU Network Object Model Environment) is a user-friendly set of
applications and desktop tools to be used in conjunction with a window
manager for the X Window System.

This package provides the GNOME session manager, as well as a
configuration program to choose applications starting on login.

%package selector
Summary: The session selector for the GNOME
Group: Graphical desktop/GNOME
Requires: %name = %EVR

%description selector
This package permits to choose a saved GNOME session.

%package wayland
Summary: A Wayland session for the GNOME
Group: Graphical desktop/GNOME
BuildArch: noarch
Requires: %name = %EVR
Requires: xorg-xwayland

%description wayland
This package permits to log into GNOME using Wayland.

%package xsession
Summary: A Xorg session for the GNOME
Group: Graphical desktop/GNOME
BuildArch: noarch
Requires: %name = %EVR
Requires(pre): xinitrc

%description xsession
This package permits to log into GNOME using Xorg.

%prep
%setup -n %name-%version%beta
%patch11 -p1 -b .nv30

%build
export PATH=$PATH:/sbin
%meson \
    %{subst_enable_meson_bool x11 x11} \
    %{subst_enable_meson_bool session_selector session_selector} \
    %{subst_enable_meson_bool docs docbook} \
    %{subst_enable_meson_bool man man}
%nil
%meson_build

%install
%meson_install

%find_lang --with-gnome --output=%name.lang %name-%ver_major

%check
%meson_test

%files -f %name.lang
%_bindir/%name
%{?_enable_x11:
%_bindir/%name-inhibit
%_bindir/%name-quit}
%_libexecdir/%name-binary
%_libexecdir/%name-ctl
%{?_enable_x11:
%_libexecdir/%name-check-accelerated
%_libexecdir/%name-check-accelerated-gl-helper
%_libexecdir/%name-check-accelerated-gles-helper}
%_libexecdir/%name-failed
%dir %_datadir/%name
%_datadir/%name/hardware-compatibility
%_datadir/xdg-desktop-portal/gnome-portals.conf
%dir %_datadir/%name/sessions
%_datadir/%name/sessions/gnome.session
%_datadir/%name/sessions/gnome-dummy.session

%config %_datadir/glib-2.0/schemas/org.gnome.SessionManager.gschema.xml
%{?_enable_man:
%_man1dir/%name-inhibit.*
%_man1dir/%name-quit.*
%_man1dir/%name.*}
%doc AUTHORS NEWS README*

%dir %_userunitdir/gnome-launched-.scope.d
%_userunitdir/gnome-launched-.scope.d/override.conf
%dir %_userunitdir/gnome-session@gnome.target.d
%_userunitdir/gnome-session@gnome.target.d/gnome.session.conf
%_userunitdir/%name-failed.service
%_userunitdir/%name-failed.target
%_userunitdir/%name-initialized.target
%_userunitdir/%name-manager.target
%_userunitdir/%name-manager@.service
%_userunitdir/%name-monitor.service
%_userunitdir/%name-pre.target
%_userunitdir/%name-restart-dbus.service
%_userunitdir/%name-shutdown.target
%_userunitdir/%name-signal-init.service
%_userunitdir/%name-wayland.target
%_userunitdir/%name-wayland@.target
%_userunitdir/%name.target
%_userunitdir/%name@.target
%{?_enable_x11:
%_userunitdir/gnome-session-x11-services-ready.target
%_userunitdir/%name-x11-services.target
%_userunitdir/%name-x11.target
%_userunitdir/%name-x11@.target
}

%if_enabled session_selector
%files selector
%{?_enable_x11:
%_bindir/%name-custom-session
%_bindir/%name-selector}
%_datadir/%name/session-selector.ui
%{?_enable_man:%_man1dir/%name-selector.*}
%_datadir/xsessions/gnome-custom-session.desktop
%endif

%files xsession
%_datadir/xsessions/gnome.desktop
%{?_enable_x11:%_datadir/xsessions/gnome-xorg.desktop}

%files wayland
%_datadir/wayland-sessions/gnome.desktop
%_datadir/wayland-sessions/gnome-wayland.desktop


%changelog
