%def_disable snapshot
%define _libexecdir %_prefix/libexec

%define ver_major 48
%define beta %nil
%define xdg_name org.gnome.SettingsDaemon

%def_enable smartcard
%def_enable systemd
%def_enable wayland
# tests require, as minimum, running colord
%def_disable check
%def_disable tests

Name: gnome-settings-daemon
Version: %ver_major.1
Release: alt1%beta

Summary: A program that manages general GNOME settings
License: GPL-2.0-or-later
Group: Graphical desktop/GNOME
Url: http://www.gnome.org

Vcs: https://gitlab.gnome.org/GNOME/gnome-settings-daemon.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources//%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define glib_ver 2.70.0
%define gtk_ver 3.16
%define gnome_desktop_ver 3.37.1
%define notify_ver 0.7.3
%define pulse_ver 2.0
%define gsds_ver 47
%define colord_ver 0.1.9
%define dconf_ver 0.8
%define upower_ver 0.99.12
%define systemd_ver 40
%define wacom_ver 0.7
%define geocode_ver 3.10.0
%define geoclue_ver 2.3.1
%define gweather_ver 3.99
%define nm_ver 1.0
%define lcms_ver 2.2
%define polkit_ver 0.114

Requires: dconf >= %dconf_ver
Requires: colord >= %colord_ver
Requires: system-config-printer-udev
Requires: rfkill
Requires: geoclue2 >= %geoclue_ver
Requires: xkeyboard-config
Requires: iio-sensor-proxy
Requires: udev-rules-rfkill-uaccess
Requires: polkit >= %polkit_ver
Requires: upower >= %upower_ver

BuildRequires(pre): rpm-macros-meson rpm-build-systemd
BuildRequires: meson gcc-c++ glib2-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgnome-desktop3-devel >= %gnome_desktop_ver
BuildRequires: libnotify-devel >= %notify_ver
BuildRequires: gsettings-desktop-schemas-devel >= %gsds_ver
BuildRequires: libpulseaudio-devel >= %pulse_ver libalsa-devel libcanberra-gtk3-devel
BuildRequires: libdbus-devel libpolkit1-devel >= %polkit_ver
BuildRequires: xkeyboard-config-devel
%{?_enable_smartcard:BuildRequires: pkgconfig(gck-2)}
%{?_enable_systemd:BuildRequires: pkgconfig(systemd) >= %systemd_ver}
%{?_enable_wayland:BuildRequires: libwayland-client-devel}
BuildRequires: libxkbfile-devel
BuildRequires: docbook-style-xsl xsltproc
BuildRequires: libcups-devel libgudev-devel
BuildRequires: pkgconfig(x11) pkgconfig(xi) pkgconfig(xext)
BuildRequires: libupower-devel >= %upower_ver
BuildRequires: libcolord-devel >= %colord_ver liblcms2-devel >= %lcms_ver librsvg-devel
BuildRequires: libwacom-devel >= %wacom_ver
BuildRequires: libgweather4.0-devel >= %gweather_ver pkgconfig(geocode-glib-2.0) >= %geocode_ver libgeoclue2-devel >= %geoclue_ver
BuildRequires: libnm-devel >= %nm_ver libmm-glib-devel pkgconfig(gcr-4)
%{?_enable_check:BuildRequires: /proc dbus gnome-color-manager}

%description
GNOME Settings Daemon is a program that organizes access to general GNOME
settings. Other GNOME programs may interact with gnome-settings-daemon to
obtain or change some settings. One of the most prominent examples of a g-s-d
client is GNOME Control Center, another one is Evolution.

%package devel
Summary: GNOME Settings Daemon development files
Group: Development/GNOME and GTK+
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package tests
Summary: GSD test programms
Group: Graphical desktop/GNOME
Requires: %name = %EVR

%description tests
The %name-tests package provides programms for testing GSD plugins.

%prep
%setup -n %name-%version%beta

%build
%meson \
    %{subst_enable_meson_bool smartcard smartcard} \
    %{subst_enable_meson_bool wayland wayland} \
    -Dudev_dir='%_udevdir'
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%check
%meson_test

%files -f %name.lang
%dir %_libdir/%name-%ver_major
%_libdir/%name-%ver_major/libgsd.so
%_libexecdir/gsd-a11y-settings
%_libexecdir/gsd-backlight-helper
%_libexecdir/gsd-color
%_libexecdir/gsd-datetime
%_libexecdir/gsd-housekeeping
%_libexecdir/gsd-keyboard
%_libexecdir/gsd-media-keys
%_libexecdir/gsd-power
%_libexecdir/gsd-print-notifications
%_libexecdir/gsd-printer
%_libexecdir/gsd-rfkill
%_libexecdir/gsd-screensaver-proxy
%_libexecdir/gsd-sharing
%_libexecdir/gsd-smartcard
%_libexecdir/gsd-sound
%_libexecdir/gsd-usb-protection
%_libexecdir/gsd-wacom
%_libexecdir/gsd-wacom-oled-helper
%_libexecdir/gsd-wwan
%_libexecdir/gsd-xsettings
%_userunitdir/*
%_datadir/%name/
%_sysconfdir/xdg/autostart/*.desktop
%dir %_sysconfdir/xdg/Xwayland-session.d
%_sysconfdir/xdg/Xwayland-session.d/00-xrdb
%config %_datadir/glib-2.0/schemas/*
%_datadir/GConf/gsettings/%name.convert
%_datadir/polkit-1/actions/org.gnome.settings-daemon.plugins.power.policy
%_datadir/polkit-1/actions/org.gnome.settings-daemon.plugins.wacom.policy
%exclude %_udevrulesdir/61-gnome-settings-daemon-rfkill.rules
%doc AUTHORS NEWS

%exclude %_udevrulesdir/61-gnome-settings-daemon-rfkill.rules

%files devel
%_includedir/%name-%ver_major/
%_pkgconfigdir/%name.pc

%if_enabled tests
%files tests
%_libexecdir/gsd-test-a11y-keyboard
%_libexecdir/gsd-test-a11y-settings
%_libexecdir/gsd-test-datetime
%_libexecdir/gsd-test-housekeeping
%_libexecdir/gsd-test-input-helper
%_libexecdir/gsd-test-keyboard
%_libexecdir/gsd-test-media-keys
%_libexecdir/gsd-test-mouse
%_libexecdir/gsd-test-orientation
%_libexecdir/gsd-test-print-notifications
%_libexecdir/gsd-test-rfkill
%_libexecdir/gsd-test-screensaver-proxy
%_libexecdir/gsd-test-smartcard
%_libexecdir/gsd-test-sound
%_libexecdir/gsd-test-wacom
%_libexecdir/gsd-test-wacom-osd
%_libexecdir/gsd-test-xrandr
%_libexecdir/gsd-test-xsettings
%endif

%changelog
