%def_disable snapshot
%define _libexecdir %_prefix/libexec
%define ver_major 46
%define beta %nil
%define old_name gnome-tweak-tool
%define xdg_name org.gnome.tweaks
%define pypi_name gtweak

%def_enable check

Name: gnome-tweaks
Version: %ver_major.1
Release: alt1%beta

Summary: A tool to customize advanced GNOME 3 options
License: GPL-3.0-or-later
Group: Graphical desktop/GNOME
Url: https://gitlab.gnome.org/GNOME/gnome-tweaks

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%endif
Patch: %name-3.27.4-alt-desktop.patch

BuildArch: noarch

%define gsds_ver 46
%define adw_ver 1.4
%define pygobject_ver 3.46.0

Requires: gnome-settings-daemon >= %ver_major
Requires: gsettings-desktop-schemas-devel >= %gsds_ver
Requires: sound-theme-freedesktop
Requires: typelib(Gtk) = 4.0 typelib(Adw) = 1

Provides: %old_name = %version-%release
Obsoletes: %old_name < 3.27.4

BuildRequires(pre): rpm-macros-meson rpm-build-gir rpm-build-python3
BuildRequires: meson
BuildRequires: gsettings-desktop-schemas-devel >= %gsds_ver
BuildRequires: pkgconfig(gobject-introspection-1.0)
BuildRequires: python3-module-pygobject3-devel >= %pygobject_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver typelib(Adw) = 1
BuildRequires: pkgconfig(gudev-1.0)
%{?_enable_check:BuildRequires:/usr/bin/appstreamcli desktop-file-utils}

%description
GNOME Tweaks is an application for changing the advanced settings
of GNOME 3.

Features:
* Install and switch gnome-shell themes
* Switch GTK+ themes
* Switch icon themes
* Change
  - The user-interface and title bar fonts
  - Icons in menus and buttons
  - Behavior on laptop lid close
  - Shell font size
  - File manager desktop icons
  - Title bar click action
  - Shell clock to show date
  - Font hinting
  - Font anti-aliasing

%prep
%setup -n %name-%version%beta
%patch -b .desktop

%build
%meson
%meson_build

%install
%meson_install
%find_lang %name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%python3_sitelibdir_noarch/%pypi_name/
%_desktopdir/%xdg_name.desktop
%_datadir/%name/
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_iconsdir/hicolor/*/*/*.svg
%_datadir/metainfo/%xdg_name.appdata.xml
%doc AUTHORS NEWS README*

%changelog
