%define _unpackaged_files_terminate_build 1

%def_with libQgpsmm
%define abiversion 30

Name: gpsd
Summary: Service daemon for mediating access to a GPS
Version: 3.25
Release: alt1
License: BSD-2-Clause
Group: System/Servers
Url: https://gpsd.gitlab.io/gpsd/index.html
VCS: https://gitlab.com/gpsd/gpsd
Source: %name-%version.tar

# Add old status names to gps.h for compatibility
Patch0: gpsd-3.25-fedora-apistatus.patch
Requires: libgps%abiversion = %EVR
BuildRequires: asciidoc docbook-dtds docbook-style-xsl asciidoctor gem-rouge

BuildRequires: scons gcc-c++ libXaw-devel libXext-devel libXpm-devel libdbus-glib-devel xorg-cf-files xsltproc libgtk+3-devel pps-tools-devel
BuildRequires: python3-dev python3-module-pycairo python3-module-pygobject3 python3-module-serial python3-module-matplotlib
BuildRequires: python3-module-setuptools
%add_findreq_skiplist */gpsdebuginfo

%if_with libQgpsmm
BuildRequires: qt5-base-devel
%endif

BuildRequires: libbluez-devel
BuildRequires: libusb-devel

%set_verify_elf_method unresolved=relaxed

%description
gpsd is a service daemon that mediates access to a GPS sensor
connected to the host computer by serial or USB interface, making its
data on the location/course/velocity of the sensor available to be
queried on TCP port 2947 of the host computer.  With gpsd, multiple
GPS client applications (such as navigational and wardriving software)
can share access to a GPS without contention or loss of data.  Also,
gpsd responds to queries with a format that is substantially easier to
parse than NMEA 0183.  A client library is provided for applications.

After installing this RPM, gpsd will automatically connect to USB
GPSes when they are plugged in and requires no configuration.  For
serial GPSes, you will need to start gpsd by hand.  Once connected,
the daemon automatically discovers the correct baudrate, stop bits,
and protocol. The daemon will be quiescent when there are no
clients asking for location information, and copes gracefully when the
GPS is unplugged and replugged.

%package -n libgps%abiversion
Summary: Client libraries in C and Python for talking to a running gpsd or GPS
Group: Sciences/Geosciences
%description -n libgps%abiversion
Client libraries in C and Python for talking to a running gpsd or GPS

%if_with libQgpsmm
%package -n libQgpsmm%abiversion
Summary: Qt bindings for gpsd
Group: Sciences/Geosciences
%description -n libQgpsmm%abiversion
This package contains Qt bindings for gpsd
%endif

%package -n libgps-devel
Summary: Development files for libgps
Group: Development/C
Requires: libgps%abiversion = %EVR
%if_with libQgpsmm
Requires: libQgpsmm%abiversion = %EVR
%endif

%description -n libgps-devel
Development files for libgps

%package -n gpsd-clients-console
Summary: Console clients for gpsd
Group: Sciences/Geosciences
Requires: libgps%abiversion = %EVR
Requires: python3-module-gps = %EVR
Conflicts: gpsd-clients < %EVR

%description -n gpsd-clients-console
Console clients pack for the gpsd

cgps resembles xgps, but without the pictorial satellite display.
It can run on a serial terminal or terminal emulator.

%package -n gpsd-clients-gui
Summary: Clients for gpsd with an X interface
Group: Sciences/Geosciences
Requires: libgps%abiversion = %EVR
Requires: python3-module-gps = %EVR
Conflicts: gpsd-clients < %EVR

%description -n gpsd-clients-gui
xgps is a simple sample client for gpsd with an X interface.
xgpsspeed is a speedometer that uses position information from gpsd.

%package -n gpsd-helpers
Summary: Helpers pack for the gpsd
Group: Sciences/Geosciences
Requires: libgps%abiversion = %EVR
Requires: python3-module-gps = %EVR
Conflicts: gpsd-clients < %EVR

%description -n gpsd-helpers
Helpers pack for the gpsd

%package -n python3-module-gps
Summary: Python bindings to libgps
Group: Development/Python

%description -n python3-module-gps
Python bindings to libgps

%prep
%setup
%patch0 -p1

%build
scons \
    prefix=/usr \
    systemd=yes \
    dbus_export=yes \
    libdir=%_libdir \
    docdir=%_defaultdocdir/%name-%version \
    icondir=%_iconsdir \
    python_libdir=%python3_sitelibdir \
    udevdir=$(dirname %{_udevrulesdir}) \
    unitdir=%{_unitdir} \
    target_python=%__python3 \
    python_shebang=%__python3 \
    %if_with libQgpsmm
	qt=yes \
	qt_versioned=5 \
    %else
	 qt=no \
    %endif
    debug=yes

%install
DESTDIR=%buildroot scons install udev-install

install -p -m 0755 gpsinit %buildroot/%_sbindir

mkdir -p %buildroot/%_desktopdir
install -p -m 0644 %name-%version/packaging/X11/xgps.desktop      %buildroot/%_desktopdir
install -p -m 0644 %name-%version/packaging/X11/xgpsspeed.desktop %buildroot/%_desktopdir

mkdir -p %buildroot/%_sysconfdir/sysconfig
install -p -m 0644 %name-%version/packaging/rpm/gpsd.sysconfig %buildroot/%_sysconfdir/sysconfig/gpsd

%files
%doc AUTHORS COPYING NEWS README.adoc INSTALL.adoc SUPPORT.adoc build.adoc www/example1.c.txt
%_sbindir/gpsd
%_man8dir/gpsd.*

%_sbindir/gpsdctl
%_man8dir/gpsdctl*

%_sbindir/gpsinit
%_man8dir/gpsinit*

%_bindir/ppscheck
%_man8dir/ppscheck*

%_unitdir/gpsd.service
%_unitdir/gpsd.socket
%_unitdir/gpsdctl@.service
%_udevrulesdir/*.rules
%config(noreplace) %attr(0644,root,root) %_sysconfdir/sysconfig/gpsd

%_man5dir/*

%_man1dir/gps.*

%_iconsdir/gpsd-logo.png
%_datadir/snmp

%files -n libgps%abiversion
%_libdir/libgps*.so.%abiversion
%_libdir/libgps*.so.%abiversion.*

%if_with libQgpsmm
%files -n libQgpsmm%abiversion
%_libdir/libQgps*.so.%abiversion
%_libdir/libQgps*.so.%abiversion.*
%endif

%files -n libgps-devel
%if_with libQgpsmm
%_libdir/libQgpsmm.so
%_libdir/libQgpsmm.prl
%endif
%_libdir/libgps*.so
%_pkgconfigdir/*.pc
%_includedir/*.h
%_man3dir/*

%files -n gpsd-clients-console
%_bindir/cgps
%_man1dir/cgps*

%_bindir/gegps
%_man1dir/gegps*

%_bindir/gpscsv
%_man1dir/gpscsv*

%_bindir/gpsdecode
%_man1dir/gpsdecode*

%_bindir/gpsmon
%_man1dir/gpsmon*

%_bindir/gpspipe
%_man1dir/gpspipe*

%_bindir/gpsplot
%_man1dir/gpsplot*

%_bindir/gpsprof
%_man1dir/gpsprof*

%_bindir/gpsrinex
%_man1dir/gpsrinex*

%_bindir/gpssubframe
%_man1dir/gpssubframe*

%_bindir/gpxlogger
%_man1dir/gpxlogger*

%_bindir/lcdgps
%_man1dir/lcdgps*

%_bindir/ubxtool
%_man1dir/ubxtool*

%_bindir/zerk
%_man1dir/zerk*

%files -n gpsd-clients-gui
%_bindir/xgps
%_desktopdir/xgps.desktop
%_man1dir/xgps*
%_bindir/xgpsspeed
%_desktopdir/xgpsspeed.desktop

%files -n gpsd-helpers
%_bindir/gps2udp
%_man1dir/gps2udp*

%_bindir/gpscat
%_man1dir/gpscat*

%_bindir/gpsctl
%_man1dir/gpsctl*

%_bindir/gpsdebuginfo
%_man1dir/gpsdebuginfo*

%_bindir/gpsfake
%_man1dir/gpsfake*

%_bindir/gpssnmp
%_man1dir/gpssnmp*

%_bindir/ntpshmmon
%_man1dir/ntpshmmon*

%files -n python3-module-gps
%python3_sitelibdir/gps/
%python3_sitelibdir/*.egg-info

%changelog
