%define _unpackaged_files_terminate_build 1
%def_with bootstrap

Name: gradle
Version: 8.14.1
Release: alt1

Summary: A highly scalable build automation tool
License: Apache-2.0
Group: Development/Java
Url: https://gradle.org
Vcs: https://github.com/gradle/gradle.git
ExcludeArch: i586

Source0: %name-%version.tar
Source1: %name-%version-vendor.tar
Source2: %name-%version-tags.tar
%if_with bootstrap
Source3: %name-%version-bin.tar
%endif
Source4: commit.sh

Patch0: %name-%version-adoptium.patch
Patch1: %name-%version-alt-git.patch
Patch2: %name-%version-alt-buildtime.patch

BuildRequires(pre): rpm-macros-java
BuildRequires: /proc
BuildRequires: rpm-build-java-osgi
BuildRequires: java-11-openjdk-devel
BuildRequires: java-17-openjdk-devel
BuildRequires: java-21-openjdk-devel
BuildRequires: git

%description
Gradle is a highly scalable build automation tool designed to handle everything from
large, multi-project enterprise builds to quick development tasks across various
languages. Gradles modular, performance-oriented architecture seamlessly integrates
with development environments, making it a go-to solution for building, testing, and
deploying applications on Java, Kotlin, Scala, Android, Groovy, C++, and Swift.

%prep
%setup -a1 -a2
%autopatch -p1

%if_with bootstrap
tar -xf %SOURCE3

# Specify the archive location.
sed -i "s#distributionUrl=.*#distributionUrl=file\:$PWD/%name-%version-bin.zip#" \
    gradle/wrapper/gradle-wrapper.properties
%endif

cp %SOURCE4 .
chmod +x commit.sh

%build
export GRADLE_USER_HOME="$PWD/.gradle"

COMMITHASH=$(./commit.sh)

# Skip task :docs:javadocAll that requires .git directory.
./gradlew installAll \
  -x :docs:javadocAll \
  -Porg.gradle.java.installations.paths="%_jvmdir/java-11-openjdk,%_jvmdir/java-17-openjdk,%_jvmdir/java-21-openjdk" \
  -Porg.gradle.java.installations.auto-detect=false \
  -Pgradle_installPath="$PWD/dist" \
  -PfinalRelease=true \
  -DbuildTimestampIso="$(date -u -d "@${SOURCE_DATE_EPOCH}" +"%%Y-%%m-%%d %%H:%%M:%%S")" \
  -DgitCommitId="$COMMITHASH" \
  -DgitBranch="sisyphus" \
  -Dorg.gradle.java.installations.auto-download=false \
  --no-configuration-cache \
  --no-build-cache \
  --offline \
  #

%install
install -Dm 644 dist/lib/*.jar \
  -t %buildroot%_javadir/gradle/lib/

install -Dm 644 dist/lib/plugins/*.jar \
  -t %buildroot%_javadir/gradle/lib/plugins/

install -Dm 644 dist/lib/agents/gradle-instrumentation-agent-%version.jar \
  -t %buildroot%_javadir/gradle/lib/agents/

install -Dm 755 dist/bin/gradle \
  -t %buildroot%_javadir/gradle/bin/

install -d %buildroot%_bindir

ln -s %_javadir/gradle/bin/gradle \
  -t %buildroot%_bindir/

%files
%_bindir/gradle
%_javadir/gradle/

%changelog
