%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%define _pseudouser_user     _greeter
%define _pseudouser_group    _greeter
%define _pseudouser_home     %_localstatedir/greeter

Name: greetd
Version: 0.10.3
Release: alt2
Summary: Generic greeter daemon
License: GPL-3.0
Group: Graphical desktop/Other
Url: https://git.sr.ht/~kennylevinsen/greetd

Source: %name-%version.tar
Source1: %name-%version-vendor.tar

# adapted pam file from Arch
Source2: %name.pam

Patch1: %name-%version-%release.patch

BuildRequires: /proc
BuildRequires: rust
BuildRequires: rust-cargo
BuildRequires: libpam-devel
BuildRequires: scdoc

Requires: greetd-greeter

%description
greetd is a minimal and flexible login manager daemon
that makes no assumptions about what you want to launch.

%package agreety
Summary: A text-based greeter for greetd
Group: Graphical desktop/Other
Requires: greetd
Provides: greetd-greeter

%description agreety
%summary.

%package fakegreet
Summary: Test utility for greeter development
Group: Development/Tools

%description fakegreet
%summary.

%prep
%setup -a1
%patch1 -p1

mkdir -p .cargo
cat > .cargo/config <<EOF
[source.crates-io]
replace-with = "vendored-sources"

[source.vendored-sources]
directory = "vendor"

[term]
verbose = true
quiet = false

[install]
root = "%buildroot%_prefix"

[build]
rustflags = ["-Copt-level=3", "-Cdebuginfo=1", "--cfg=rustix_use_libc"]

[profile.release]
strip = false

[dependencies]
rustix = { features = ["cc"] }
EOF

%build
cargo build \
	--release \
	%{?_smp_mflags} \
	--offline \
	%nil

pushd man
for i in *.scd
do
	scdoc < "$i" > "$(basename "$i" .scd)".roff
done
popd

%install
install -Dm755 target/release/greetd %buildroot%_bindir/greetd
install -Dm755 target/release/agreety %buildroot%_bindir/agreety
install -Dm755 target/release/fakegreet %buildroot%_bindir/fakegreet

pushd man
for s in 1 5 7
do
	install -d "%buildroot%_mandir/man$s"
	for i in *-$s.roff
	do
		install -m755 "$i" "%buildroot%_mandir/man$s/${i%-*}.$s"
	done
done
popd

install -Dm644 greetd.service %buildroot%_unitdir/greetd.service

echo 'u _greeter - "greetd greeter user" %_pseudouser_home /bin/bash' |
	install -Dm644 /dev/stdin %buildroot/%_sysusersdir/%name.conf

echo 'd %_pseudouser_home 0750 _greeter _greeter' |
	install -Dm644 /dev/stdin %buildroot/%_tmpfilesdir/%name.conf

mkdir -p %buildroot%_sysconfdir/greetd/greeters

install -Dm644 %SOURCE2 %buildroot%_sysconfdir/pam.d/greetd
install -Dm644 config.toml %buildroot%_sysconfdir/greetd/greeters/agreety.toml

mkdir -p %buildroot%_altdir
echo "%_sysconfdir/greetd/config.toml %_sysconfdir/greetd/greeters/agreety.toml 100" \
	> %buildroot%_altdir/greetd-agreety

%pre
/usr/sbin/groupadd -r -f %_pseudouser_group ||:
/usr/sbin/useradd -g %_pseudouser_group -c 'greetd greeter user' \
	-d %_pseudouser_home -s /dev/null -r %_pseudouser_user >/dev/null 2>&1 ||:

%files
%doc LICENSE
%doc README.md
%_bindir/greetd
%dir %_sysconfdir/greetd
%config(noreplace) %_sysconfdir/pam.d/greetd
%_unitdir/greetd.service
%_sysusersdir/%name.conf
%_tmpfilesdir/%name.conf
%_man1dir/greetd-*.1*
%_man5dir/greetd-*.5*
%_man7dir/greetd-*.7*

%files agreety
%_bindir/agreety
%_altdir/greetd-agreety
%config(noreplace) %_sysconfdir/greetd/greeters/agreety.toml
%_man1dir/agreety-*.1*

%files fakegreet
%_bindir/fakegreet

%triggerin -- %name < 0.10.3-alt2
/usr/sbin/usermod -d %_pseudouser_home %_pseudouser_user >/dev/null 2>&1 ||:

%changelog
