%def_disable snapshot

%define ver_major 0.3
%define api_ver %ver_major
%define namespace Grl
%def_enable soup3
%def_enable gtk_doc
%def_disable check

Name: grilo
Version: %ver_major.19
Release: alt1

Summary: Content discovery framework
Group: Sound
License: LGPL-2.1-or-later
Url: https://wiki.gnome.org/Projects/Grilo

Vcs: https://gitlab.gnome.org/GNOME/grilo.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
Patch10: grilo-0.3.15-alt-potfiles.patch

BuildRequires(pre): rpm-macros-meson rpm-build-python3 rpm-build-gir
BuildRequires: meson
BuildRequires: libgio-devel >= 2.66
BuildRequires: libxml2-devel
BuildRequires: libgtk+3-devel >= 3.0
%if_disabled soup3
BuildRequires: libsoup-devel >= 2.41.3 libsoup-gir-devel
%else
BuildRequires: libsoup3.0-devel >= 3.0.0 libsoup3.0-gir-devel
%endif
BuildRequires: liboauth-devel
BuildRequires: vala-tools >= 0.27 libvala-devel
BuildRequires: gtk-doc >= 1.10
BuildRequires: gobject-introspection-devel >= 0.9.0
BuildRequires: libtotem-pl-parser-devel >= 3.4.1
BuildRequires: gstreamer1.0-devel
%{?_enable_check:BuildRequires: xvfb-run %name-plugins}

%description
Grilo is a framework that provides access to different sources of
multimedia content, using a pluggable system.
This package contains the core library and elements.

%package -n lib%name
Summary: Libraries files for Grilo framework
Group: System/Libraries

%description -n lib%name
Grilo is a framework that provides access to different sources of
multimedia content, using a pluggable system.
This package contains the core library.

%package -n lib%name-devel
Summary: Development files for Grilo framework
Group: Development/Other
Requires: lib%name = %EVR

%description -n lib%name-devel
Grilo is a framework that provides access to different sources of
multimedia content, using a pluggable system.
This package contains the core library and elements, as well as
general and API documentation.

%package devel-doc
Summary: Development documentation for %name
Group: Development/GNOME and GTK+
Conflicts: lib%name < %version-%release
BuildArch: noarch

%description devel-doc
This package provides development documentation for %name.

%package -n lib%name-gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the %name library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the %name library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-devel = %EVR
Requires: lib%name-gir = %EVR

%description -n lib%name-gir-devel
GObject introspection devel data for the %name library

%package tools
Summary: Tools for the %name library
Group: Sound
Requires: lib%name = %EVR

%description tools
Tools for the %name library

%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup
%patch10 -p1

%build
%meson \
    %{subst_enable_meson_bool soup3 soup3} \
    -Denable-vala=true \
    -Denable-gtk-doc=true \
    -Denable-introspection=true \
    -Denable-grl-net=true \
    -Denable-grl-pls=true \
    -Denable-test-ui=true
%nil
%meson_build

%install
%meson_install
mkdir -p %buildroot%_libdir/grilo-%ver_major %buildroot%_datadir/grilo-%ver_major/plugins
%find_lang %name

%check
export LANG=en_US.UTF-8
xvfb-run %__meson_test

%files tools
%doc AUTHORS COPYING NEWS README* TODO
%_bindir/grl-inspect-%api_ver
%_bindir/grl-launch-%api_ver
%_bindir/grilo-test-ui-%api_ver
%_man1dir/*

%files -n lib%name -f %name.lang
%_libdir/*.so.*
%dir %_libdir/grilo-%ver_major
%dir %_datadir/grilo-%ver_major/plugins

%files -n lib%name-devel
%_includedir/%name-%api_ver/
%_libdir/*.so
%_pkgconfigdir/*-%api_ver.pc
%_vapidir/*

%files -n lib%name-gir
%_typelibdir/%namespace-%api_ver.typelib
%_typelibdir/%{namespace}Net-%api_ver.typelib
%_typelibdir/%{namespace}Pls-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/%namespace-%api_ver.gir
%_girdir/%{namespace}Net-%api_ver.gir
%_girdir/%{namespace}Pls-%api_ver.gir

%if_enabled gtk_doc
%files devel-doc
%_gtk_docdir/%name/
%endif

%changelog
