%define _unpackaged_files_terminate_build 1
%define libgslver 28
%define libgslcblasver 0

Name: gsl
Version: 2.8
Release: alt4
Summary: The GNU Scientific Library for numerical analysis
License: GPLv3
Group: Development/Other
URL: https://www.gnu.org/software/gsl/gsl.html
VCS: https://git.savannah.gnu.org/git/gsl.git
Source: %name-%version.tar
Patch0: gsl-2.7-alt-build.patch
Patch1: gsl-2.8-debian-CVE-2024-50610-fix.patch
Conflicts: lib%name-devel < %EVR
BuildRequires: ghostscript-module-X ghostscript-utils
# explicitly added texinfo for info files
BuildRequires: texinfo
BuildRequires: python3-module-sphinx python3-module-sphinx-sphinx-build-symlink python3-module-sphinx_rtd_theme

%package -n libgslcblas%libgslcblasver
Summary: BLAS Shared librairy for GNU Scientific Library
Group: System/Libraries
Conflicts: libgsl < 2.8-alt1

%package -n libgsl%libgslver
Summary: Shared librairy for GNU Scientific Library (GSL)
Group: System/Libraries
Obsoletes: libgsl

%package -n lib%name-devel
Summary: Development environment for GNU Scientific Library (GSL)
Group: Development/C
Requires: libgsl%libgslver = %EVR
Requires: libgslcblas%libgslcblasver = %EVR

%package -n lib%name-doc
Summary: book for Scientific Library
Group: Documentation
BuildArch: noarch

%package -n lib%name-info
Summary: Info pages for Scientific Library
Group: Documentation
BuildArch: noarch
Conflicts: %name < %EVR

%package -n lib%name-examples
Summary: Examples sources for using with Scientific Library
Group: Documentation
BuildArch: noarch

%description
The %name package is part of the GNU Scientific Library (GSL). The GSL is a
collection of routines for numerical analysis, written in C.  The GSL is
in alpha development.  It now includes a random number suite, an FFT
package, simulated annealing and root finding.  In the future, it will
include numerical and Monte Carlo integration and special functions.
Linking against the GSL allows programs to access functions which can
handle many of the problems encountered in scientific computing.

Install the %name package if you need utilities for high-level scientific
numerical analysis.

%description -n libgslcblas%libgslcblasver
The libgslcblas package is part of the GNU Scientific Library (GSL).
The GNU Scientific Library (GSL) is a collection of routines for numerical
computing. The routines have been written from scratch in C, and present a
modern Applications Programming Interface (API) for C programmers,
allowing wrappers to be written for very high level languages.

Linking against the GSL allows programs to access functions which can
handle many of the problems encountered in scientific computing.

This package contains shared library required for run GSL-based software.

%description -n libgsl%libgslver
The libgsl package is part of the GNU Scientific Library (GSL).
The GNU Scientific Library (GSL) is a collection of routines for numerical
computing. The routines have been written from scratch in C, and present a
modern Applications Programming Interface (API) for C programmers,
allowing wrappers to be written for very high level languages.

Linking against the GSL allows programs to access functions which can
handle many of the problems encountered in scientific computing.

This package contains shared library required for run GSL-based software.

%description -n libgsl-devel
The libgsl-devel package is part of the GNU Scientific Library (GSL).
The GNU Scientific Library (GSL) is a collection of routines for numerical
computing. The routines have been written from scratch in C, and present a
modern Applications Programming Interface (API) for C programmers,
allowing wrappers to be written for very high level languages.

Linking against the GSL allows programs to access functions which can
handle many of the problems encountered in scientific computing.

This package contains shared libs and include headers required for development.

%description -n lib%name-doc
book for developers

%description -n lib%name-info
Info pages for GSL

%description -n lib%name-examples
Sources of examples for using with GSL

%prep
%setup
%patch0 -p1
%patch1 -p1

%build
%autoreconf
%configure
%make_build

%install
%makeinstall

rm -f %buildroot%_libdir/*.a

%files
%_bindir/*
%exclude %_bindir/%name-config
%_man1dir/*
%exclude %_man1dir/%name-config.1*

%files -n libgsl%libgslver
%doc AUTHORS
%_libdir/libgsl.so.%libgslver
%_libdir/libgsl.so.%libgslver.*

%files -n libgslcblas%libgslcblasver
%_libdir/libgslcblas.so.%libgslcblasver
%_libdir/libgslcblas.so.%libgslcblasver.*

%files -n lib%name-devel
%doc ChangeLog NEWS README THANKS TODO DONE VOLUNTEERS NOTES
%_bindir/%name-config
%_libdir/*.so
%_pkgconfigdir/*
%_includedir/*
%_datadir/aclocal/*
%_man1dir/%name-config.1*
%_man3dir/*

%files -n lib%name-info
%_infodir/*.info*

%files -n lib%name-examples
%doc doc/examples

%changelog
