%def_disable snapshot

%define ver_major 1.57

# obexftp support removed since 3.15.91
%def_disable obexftp
%def_enable afc
%def_enable afp
%def_enable archive
%def_enable avahi
%def_enable bluray
%def_enable cdda
%def_enable fuse
%def_enable gcr
%def_enable goa
%def_enable gphoto2
%def_enable http
%def_enable installed_tests
%def_enable keyring
%def_enable libmtp
%def_enable nfs
%def_enable samba
%def_enable systemd_login
%def_enable udisks2
%def_enable google
%def_enable admin
%def_enable libusb
%def_enable dnssd
%def_enable onedrive
%def_enable wsdd
%def_enable man
%def_enable devel_utils
%def_disable check

Name: gvfs
Version: %ver_major.2
Release: alt1

Summary: The GNOME virtual filesystem libraries
License: LGPL-2.0-or-later
Group: System/Libraries
Url: https://wiki.gnome.org/Projects/gvfs

Vcs: https://gitlab.gnome.org/GNOME/gvfs.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
# https://bugzilla.altlinux.org/show_bug.cgi?id=29047
# https://bugzilla.altlinux.org/show_bug.cgi?id=29171
# https://mail.gnome.org/archives/gvfs-list/2013-May/msg00014.html
Patch1: gvfs-1.19.90-alt-1-logind-state.patch

# obsolete by %_bindir/gio from libgio
Obsoletes: %name-utils < 1.31
Obsoletes: bash-completion-gvfs < 1.31

%define glib_ver 2.83.0
%define gudev_ver 207
%define libsoup3_ver 3.0.0
%define avahi_ver 0.6
%define libcdio_paranoia_ver 10.2
%define bluez_ver 4.0
%define udisks_ver 1.99
%define mtp_ver 1.1.12
%define goa_ver 3.17.1
%define libarchive_ver 3.0.22
%define imobiledevice_ver 1.3
%define nfs_ver 1.9.8
%define gdata_ver 0.18.0
%define gcrypt_ver 1.2.2
%define libusb_ver 1.0.21
%define gphoto_ver 2.4.0
%define gsds_ver 3.33.0
%define msgraph_ver 0.3.3

Requires: dconf
Requires: gsettings-desktop-schemas >= %gsds_ver
%{?_enable_fuse:Requires: fuse-gvfs}
%{?_enable_udisks2:Requires: udisks2}

BuildRequires(pre): meson rpm-build-gnome rpm-build-python3
%add_python3_path %_libexecdir/installed-tests/%name

BuildRequires: libgio-devel >= %glib_ver
BuildRequires: gsettings-desktop-schemas-devel >= %gsds_ver
BuildRequires: libdbus-devel
BuildRequires: openssh-clients
BuildRequires: libgudev-devel >= %gudev_ver
BuildRequires: pkgconfig(libgcrypt) pkgconfig(gcr-4)
%{?_enable_afc:BuildRequires: libimobiledevice-devel >= %imobiledevice_ver pkgconfig(libplist-2.0)}
%{?_enable_afp:BuildRequires: libgcrypt-devel >= %gcrypt_ver}
%{?_enable_archive:BuildRequires: libarchive-devel >= %libarchive_ver}
%{?_enable_dnssd:BuildRequires: libavahi-glib-devel >= %avahi_ver libavahi-devel >= %avahi_ver}
%{?_enable_bluray:BuildRequires: libbluray-devel}
%{?_enable_cdda:BuildRequires: libcdio-paranoia-devel >= %libcdio_paranoia_ver}
%{?_enable_fuse:BuildRequires: libfuse3-devel}
%{?_enable_gcr:BuildRequires: gcr-libs-devel}
%{?_enable_goa:BuildRequires: libgnome-online-accounts-devel >= %goa_ver}
%{?_enable_gphoto2:BuildRequires: libgphoto2-devel >= %gphoto_ver}
%{?_enable_http:BuildRequires: libsoup3.0-devel >= %libsoup3_ver libxml2-devel}
%{?_enable_keyring:BuildRequires: libsecret-devel}
%{?_enable_libmtp:BuildRequires: libmtp-devel >= %mtp_ver}
%{?_enable_nfs:BuildRequires: libnfs-devel >= %nfs_ver}
%{?_enable_obexftp:BuildRequires: libbluez-devel >= %bluez_ver libdbus-glib-devel libexpat-devel}
%{?_enable_samba:BuildRequires: libsmbclient-devel}
%{?_enable_systemd_login:BuildRequires: libsystemd-devel}
%{?_enable_udisks2:BuildRequires: libudisks2-devel >= %udisks_ver}
%{?_enable_google:BuildRequires: libgdata-devel >= %gdata_ver}
%{?_enable_admin:BuildRequires: libpolkit-devel libcap-devel}
%{?_enable_libusb:BuildRequires: libusb-devel >= %libusb_ver}
%{?_enable_onedrive:BuildRequires: libmsgraph-devel >= %msgraph_ver}
%{?_enable_man:BuildRequires: xsltproc docbook-dtds docbook-style-xsl}

BuildRequires: desktop-file-utils
BuildRequires: gcc-c++ perl-XML-Parser

%if_enabled check
BuildRequires: /proc dbus-tools-gui python3 python3-module-pygobject3 python-module-twisted-core
BuildRequires:  openssh-server apache2 samba genisoimage
# and more ...
%endif

%package -n fuse-%name
Summary: gvfs fuse gateway
Group: System/Kernel and hardware
Requires: %name = %EVR
Requires: %{get_dep fuse3}

%package backend-smb
Summary: Samba backend for gvfs
Group: System/Libraries
Requires: %name = %EVR
Requires: samba-client

%package backend-obexftp
Summary: Obexftp backend for gvfs
Group: System/Libraries
Requires: %name = %EVR

%package backend-dnssd
Summary: Dnssd(avahi) backend for gvfs
Group: System/Libraries
Requires: %name = %EVR

%package backend-cdda
Summary: Music CD-ROM backend for gvfs
Group: System/Libraries
Requires: %name = %EVR

%package backend-afc
Summary: i{Phone,Pod} backend for gvfs
Group: System/Libraries
Requires: %name = %EVR
Requires: usbmuxd

%package backend-afp
Summary: Apple Filing Protocol backend for gvfs
Group: System/Libraries
Requires: %name = %EVR

%package backend-recent-files
Summary: Recent files backend for gvfs
Group: System/Libraries
Requires: %name = %EVR

%package backend-goa
Summary: gnome-online-accounts backend for gvfs
Group: System/Libraries
Requires: %name = %EVR
Requires: gnome-online-accounts

%package backend-mtp
Summary: MTP support for gvfs
Group: System/Libraries
Requires: %name = %EVR

%package backend-nfs
Summary: NFS backend for gvfs
Group: System/Libraries
Requires: %name = %EVR
Requires: nfs-clients
Requires(post): libcap-utils

%package backend-google
Summary: Google drive backend for gvfs
Group: System/Libraries
Requires: %name = %EVR
Requires: gnome-online-accounts

%package backend-admin
Summary: Admin backend for gvfs
Group: System/Libraries
Requires: %name = %EVR
Requires: polkit

%package backend-onedrive
Summary: OneDrive backend for gvfs
Group: System/Libraries
Requires: %name = %EVR

%package backend-wsdd
Summary: WSDD backend for gvfs
Group: System/Libraries
Requires: %name = %EVR
Requires: wsdd

%package backends
Summary: All backends for gvfs
Group: System/Libraries
BuildArch: noarch
Requires: gvfs  = %EVR
Requires: gvfs-backend-smb = %EVR
Requires: gvfs-backend-dnssd = %EVR
Requires: gvfs-backend-recent-files = %EVR
%{?_enable_cdda:Requires: gvfs-backend-cdda = %EVR}
%{?_enable_obexftp:Requires: gvfs-backend-obexftp = %EVR}
%{?_enable_afc:Requires: gvfs-backend-afc = %EVR}
%{?_enable_afp:Requires: gvfs-backend-afp = %EVR}
%{?_enable_goa:Requires: gvfs-backend-goa = %EVR}
%{?_enable_libmtp:Requires: gvfs-backend-mtp = %EVR}
%{?_enable_nfs:Requires: gvfs-backend-nfs = %EVR}
%{?_enable_google:Requires: gvfs-backend-google = %EVR}
%{?_enable_admin:Requires: gvfs-backend-admin = %EVR}
%{?_enable_onedrive:Requires: gvfs-backend-onedrive = %EVR}
%{?_enable_wsdd:Requires: gvfs-backend-wsdd = %EVR}

%description
gvfs is a userspace virtual filesystem where mount runs as a separate
processes which you talk to via dbus. It also contains a gio module that
seamlessly adds gvfs support to all applications using the gio API. It also
supports exposing the gvfs mounts to non-gio applications using fuse.

This package contains the gvfs server, libgvfscommon library, gio
modules and backends for gvfs: archive, computer, dav, ftp,
gphoto2, http, localtest, network, sftp and trash.

%description -n fuse-%name
fuse-gvfs is a bridge between the gvfs filesystem design and fuse, a
program to mount user-space filesystems.

%description backend-smb
This package contains the smb and smb-browse backends for gvfs.

%description backend-obexftp
This package contains the obexftp backend for gvfs.

%description backend-dnssd
This package contains the dnssd backend for gvfs.

%description backend-cdda
This package contains the cdda backend for gvfs.

%description backend-afc
This package contains a backend for gvfs, providing access to Apple's
iPhone, and iPod Touch devices.

%description backend-afp
This package contains a backend for gvfs, providing access to Apple
Mac OS X filesystem by AFP (Apple Filing Protocol) network protocol.

%description backend-recent-files
This package contains recent files backend for gvfs.

%description backend-goa
This package contains gnome-online-accounts backend for gvfs.

%description backend-mtp
This package provides support for reading and writing files on MTP based
devices (Media Transfer Protocol) to applications using gvfs.

%description backend-nfs
This package provides support for mounting NFS shares using gvfs.

%description backend-google
This package provides support for mounting google drive using gvfs.

%description backend-admin
This package provides admin backend for gvfs based on polkit.

%description backend-onedrive
This package provides OneDrive backend for gvfs.

%description backend-wsdd
This package provides WSDD backend for gvfs.

%description backends
This virtual package contains the all backends for gvfs.

%package tests
Summary: GVFS test programms
Group: Development/GNOME and GTK+
BuildArch: noarch
Requires: %name-backends = %EVR fuse-%name

%description tests
The %name-tests package provides programms for testing GVFS.

%define _libexecdir %_prefix/libexec/%name

%prep
%setup
#%%patch1 -p2 -b .logind-state

%build
%meson \
    %{subst_enable_meson_bool http http} \
    %{subst_enable_meson_bool dnssd dnssd} \
    %{subst_enable_meson_bool cdda cdda} \
    %{subst_enable_meson_bool fuse fuse} \
    %{subst_enable_meson_bool gphoto2 gphoto2} \
    %{subst_enable_meson_bool keyring keyring} \
    %{subst_enable_meson_bool samba smb} \
    %{subst_enable_meson_bool archive archive} \
    %{subst_enable_meson_bool afc afc} \
    %{subst_enable_meson_bool afp afp} \
    %{subst_enable_meson_bool udisks2 udisks2} \
    %{subst_enable_meson_bool libmtp mtp} \
    %{subst_enable_meson_bool bluray bluray} \
    %{subst_enable_meson_bool nfs nfs} \
    %{subst_enable_meson_bool google google} \
    %{subst_enable_meson_bool libusb libusb} \
    %{subst_enable_meson_bool onedrive onedrive} \
    %{subst_enable_meson_bool wsdd wsdd} \
    %{subst_enable_meson_bool systemd_login logind} \
    %{subst_enable_meson_bool man man} \
    %{subst_enable_meson_bool installed_tests installed_tests} \
    %{subst_enable_meson_bool devel_utils devel_utils}
%nil
%meson_build

%install
%meson_install
%find_lang %name

%check
export PATH=/usr/sbin:$PATH
%__meson_test

%post
killall -USR1 gvfsd >&/dev/null || :

%post backend-nfs
# for privileged ports
setcap -q cap_net_bind_service=ep %_libexecdir/gvfsd-nfs ||:


%files -f %name.lang
%doc NEWS README* monitor/udisks2/what-is-shown.txt
%dir %_libdir/%name
%_libdir/%name/libgvfs*.so
%dir %_libexecdir
# daemon
%_libexecdir/gvfsd
%config %_datadir/glib-2.0/schemas/org.gnome.system.gvfs.enums.xml
%_prefix/lib/systemd/user/gvfs-daemon.service
%_prefix/lib/systemd/user/gvfs-metadata.service
# monitors
%_libexecdir/gvfs-gphoto2-volume-monitor
%_prefix/lib/systemd/user/gvfs-gphoto2-volume-monitor.service
%{?_enable_udisks2:%_libexecdir/gvfs-udisks2-volume-monitor}
%{?_enable_udisks2:%_prefix/lib/systemd/user/gvfs-udisks2-volume-monitor.service}
%_datadir/dbus-1/services/*
# gio modules
%_libdir/gio/modules/*.so
# default backends
%_libexecdir/gvfsd-*

%exclude %_libexecdir/gvfsd-fuse

%dir %_datadir/%name
%dir %_datadir/%name/remote-volume-monitors
%_datadir/%name/remote-volume-monitors/gphoto2.monitor
%{?_enable_udisks2:%_datadir/%name/remote-volume-monitors/udisks2.monitor}

%_datadir/%name/mounts

%if_enabled man
%_man1dir/gvfsd-fuse.1.*
%_man1dir/gvfsd-metadata.1.*
%_man1dir/gvfsd.1.*
%_man7dir/gvfs.7.*
%endif

# in another packages
%exclude %_libexecdir/gvfsd-recent
%exclude %_datadir/%name/mounts/recent.mount

%if_enabled samba
    %exclude %_libexecdir/gvfsd-smb
    %exclude %_libexecdir/gvfsd-smb-browse
    %exclude %_datadir/%name/mounts/smb.mount
    %exclude %_datadir/%name/mounts/smb-browse.mount
%endif

%{?_enable_cdda:%exclude %_libexecdir/gvfsd-cdda}

%if_enabled obexftp
    %exclude %_libexecdir/gvfsd-obexftp
    %exclude %_datadir/%name/mounts/obexftp.mount
%endif

%if_enabled afc
    %exclude %_libexecdir/gvfsd-afc
    %exclude %_datadir/%name/mounts/afc.mount
%endif

%if_enabled afp
    %exclude %_libexecdir/gvfsd-afp
    %exclude %_libexecdir/gvfsd-afp-browse
    %exclude %_datadir/%name/mounts/afp.mount
    %exclude %_datadir/%name/mounts/afp-browse.mount
%endif

%{?_enable_cdda:%exclude %_datadir/%name/mounts/cdda.mount}
%{?_enable_dnssd:%exclude %_libexecdir/gvfsd-dnssd}
%{?_enable_dnssd:%exclude %_datadir/%name/mounts/dns-sd.mount}

%if_enabled libmtp
    %exclude %_libexecdir/gvfsd-mtp
    %exclude %_datadir/%name/mounts/mtp.mount
    %exclude %_datadir/dbus-1/services/org.gtk.vfs.MTPVolumeMonitor.service
%endif

%if_enabled nfs
    %exclude %_libexecdir/gvfsd-nfs
    %exclude %_datadir/%name/mounts/nfs.mount
%endif

%if_enabled google
    %exclude %_libexecdir/gvfsd-google
    %exclude %_datadir/%name/mounts/google.mount
%endif

%if_enabled admin
    %exclude %_libexecdir/gvfsd-admin
    %exclude %_datadir/%name/mounts/admin.mount
%endif

%if_enabled onedrive
    %exclude %_libexecdir/gvfsd-onedrive
    %exclude %_datadir/%name/mounts/onedrive.mount
%endif

%if_enabled wsdd
    %exclude %_libexecdir/gvfsd-wsdd
    %exclude %_datadir/%name/mounts/wsdd.mount
%endif

%files -n fuse-%name
%_libexecdir/gvfsd-fuse
%_tmpfilesdir/gvfsd-fuse-tmpfiles.conf

%files backend-smb
%_libexecdir/gvfsd-smb
%_libexecdir/gvfsd-smb-browse
%_datadir/%name/mounts/smb.mount
%_datadir/%name/mounts/smb-browse.mount
%config %_datadir/glib-2.0/schemas/org.gnome.system.smb.gschema.xml
%_datadir/GConf/gsettings/gvfs-smb.convert

%if_enabled obexftp
%files backend-obexftp
%_libexecdir/gvfsd-obexftp
%_datadir/%name/mounts/obexftp.mount
%endif

%if_enabled dnssd
%files backend-dnssd
%_libexecdir/gvfsd-dnssd
%_datadir/%name/mounts/dns-sd.mount
%config %_datadir/glib-2.0/schemas/org.gnome.system.dns_sd.gschema.xml
%_datadir/GConf/gsettings/gvfs-dns-sd.convert
%endif

%if_enabled cdda
%files backend-cdda
%_libexecdir/gvfsd-cdda
%_datadir/%name/mounts/cdda.mount
%endif

%if_enabled afc
%files backend-afc
%_libexecdir/gvfsd-afc
%_libexecdir/gvfs-afc-volume-monitor
%_datadir/%name/mounts/afc.mount
%_datadir/%name/remote-volume-monitors/afc.monitor
%_prefix/lib/systemd/user/gvfs-afc-volume-monitor.service
%endif

%if_enabled afp
%files backend-afp
%_libexecdir/gvfsd-afp
%_libexecdir/gvfsd-afp-browse
%_datadir/%name/mounts/afp.mount
%_datadir/%name/mounts/afp-browse.mount
%endif

%files backend-recent-files
%_libexecdir/gvfsd-recent
%_datadir/%name/mounts/recent.mount

%if_enabled goa
%files backend-goa
%_libexecdir/%name-goa-volume-monitor
%_datadir/%name/remote-volume-monitors/goa.monitor
%_prefix/lib/systemd/user/gvfs-goa-volume-monitor.service
%endif

%if_enabled libmtp
%files backend-mtp
%_libexecdir/gvfsd-mtp
%_libexecdir/gvfs-mtp-volume-monitor
%_datadir/%name/mounts/mtp.mount
%_datadir/%name/remote-volume-monitors/mtp.monitor
%_datadir/dbus-1/services/org.gtk.vfs.MTPVolumeMonitor.service
%_prefix/lib/systemd/user/gvfs-mtp-volume-monitor.service
%endif

%if_enabled nfs
%files backend-nfs
%_libexecdir/gvfsd-nfs
%_datadir/%name/mounts/nfs.mount
%endif

%if_enabled google
%files backend-google
%_libexecdir/gvfsd-google
%_datadir/%name/mounts/google.mount
%endif

%if_enabled admin
%files backend-admin
%_libexecdir/gvfsd-admin
%_datadir/%name/mounts/admin.mount
%_datadir/polkit-1/actions/org.gtk.vfs.file-operations.policy
%_datadir/polkit-1/rules.d/org.gtk.vfs.file-operations.rules
%endif

%if_enabled onedrive
%files backend-onedrive
%_libexecdir/gvfsd-onedrive
%_datadir/%name/mounts/onedrive.mount
%endif

%if_enabled wsdd
%files backend-wsdd
%_libexecdir/gvfsd-wsdd
%_datadir/%name/mounts/wsdd.mount
%config %_datadir/glib-2.0/schemas/org.gnome.system.wsdd.gschema.xml
%endif

%files backends

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%name/
%_datadir/installed-tests/%name/
%endif


%changelog
