%define _unpackaged_files_terminate_build 1
%define ver 9

Name:    gz-gui
Version: %ver.0.0
Release: alt2

Summary: Builds on top of Qt to provide widgets which are useful when developing robotics applications, such as a 3D view, plots, dashboard, etc, and can be used together in a convenient unified interface
License: Apache-2.0
Group:   Development/C++

Url:      https://github.com/gazebosim/gz-gui
Source:   %name-%version.tar
Packager: Andrey Cherepanov <cas@altlinux.org>

# Same as for ogre-next via libgz-rendering-devel
ExclusiveArch: x86_64 %e2k

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires: gcc-c++
BuildRequires: gz-cmake
BuildRequires: protobuf-compiler
BuildRequires: libtinyxml2-devel
BuildRequires: libgz-msgs-devel >= 8.0.0
BuildRequires: libgz-transport-devel >= 11.0.0
BuildRequires: libgz-rendering-devel >= 6.0.0
BuildRequires: libgz-common-devel
BuildRequires: libgz-plugin-devel
BuildRequires: qt5-base-devel
BuildRequires: qt5-quick1-devel
BuildRequires: qt5-quickcontrols2-devel
BuildRequires: libstdc++-devel-static

%description
Gazebo GUI builds on top of Qt to provide widgets which are useful when
developing robotics applications, such as a 3D view, plots, dashboard, etc,
and can be used together in a convenient unified interface.

%package -n lib%name
Summary: Library of %name
Group: System/Libraries
Requires: qt5-quickcontrols
Requires: qt5-quickcontrols2

%description -n lib%name
%summary

%package -n lib%{name}-devel
Summary: Development files for %name
Group: Development/C++

%description -n lib%{name}-devel
%summary

%prep
%setup

%build
%cmake -GNinja -Wno-dev
%ninja_build -C "%_cmake__builddir"

%install
%ninja_install -C "%_cmake__builddir"
# Replace libGrid3D.so by libGridConfig.so without RPATH
rm -f %buildroot%_libdir/gz-gui-%ver/plugins/libGrid3D.so
cp %buildroot%_libdir/gz-gui-%ver/plugins/{libGridConfig.so,libGrid3D.so}

%files -n lib%name
%doc AUTHORS README.md
%_libexecdir/ruby/*
%_libdir/lib*.so.*
%_libdir/lib*.so
%_libdir/gz-gui-*/plugins
%_datadir/gz/gui*.yaml
%_datadir/gz/gz2.completion.d/gui*.bash_completion.sh

%files -n lib%{name}-devel
%_includedir/gz/*
%_cmakedir/*
%_pkgconfigdir/*.pc

%changelog
