%define haproxy_user    _haproxy
%define haproxy_group   %haproxy_user
%define haproxy_home    %_localstatedir/haproxy
%define haproxy_confdir %_sysconfdir/haproxy
%define haproxy_datadir %_datadir/haproxy

%def_enable lua

Name: haproxy
Version: 3.0.12
Release: alt1

Summary: HA-Proxy is a TCP/HTTP reverse proxy for high availability environments
License: GPLv2+
Group: System/Servers

URL: http://www.haproxy.org/
Source: %name-%version.tar
Source1: %name.cfg
Source2: %name.init
Source3: %name.logrotate
Source4: %name.service
Source5: %name.sysconfig

BuildRequires: libpcre2-devel zlib-devel libssl-devel libsystemd-devel
%{?_enable_lua:BuildRequires: liblua5-devel >= 5.3}

%description
HA-Proxy is a TCP/HTTP reverse proxy which is particularly suited for high
availability environments. Indeed, it can:
- route HTTP requests depending on statically assigned cookies
- spread the load among several servers while assuring server persistence
  through the use of HTTP cookies
- switch to backup servers in the event a main one fails
- accept connections to special ports dedicated to service monitoring
- stop accepting connections without breaking existing ones
- add/modify/delete HTTP headers both ways
- block requests matching a particular pattern

It needs very little resource. Its event-driven architecture allows it to easily
handle thousands of simultaneous connections on hundreds of instances without
risking the system's stability.

%prep
%setup

%build
export VERDATE="$(date '+%%+4Y/%%m/%%d')"
export VERSION="%version"
export SUBVERS="-%release"
%make_build V=1 CPU="generic" TARGET="linux-glibc" USE_OPENSSL=1 USE_QUIC=1 USE_QUIC_OPENSSL_COMPAT=1 \
    USE_PCRE2=1 USE_PCRE2_JIT=1 \
    USE_SLZ=1 %{?_enable_lua:USE_LUA=1} \
%ifarch mipsel
    USE_LIBATOMIC=1 \
%endif
    USE_SYSTEMD=1 USE_PROMEX=1 USE_LINUX_CAP=1 PREFIX="%_prefix"  DEFINE=-DMAX_SESS_STKCTR=12 ADDINC="%optflags" \
    EXTRA=admin/halog/halog

%install
%make_install install-bin DESTDIR=%buildroot PREFIX="%_prefix" TARGET="linux-glibc"
%make_install install-man DESTDIR=%buildroot PREFIX="%_prefix"

install -p -D -m 0644 %SOURCE1 %buildroot%haproxy_confdir/%name.cfg
install -d -m 0755 %buildroot%haproxy_confdir/conf.d
install -D -m 0755 %SOURCE2 %buildroot%_initrddir/haproxy
install -p -D -m 0644 %SOURCE5 %buildroot%_sysconfdir/sysconfig/%name
install -p -D -m 0644 %SOURCE4 %buildroot%_unitdir/%name.service
install -p -D -m 0644 %SOURCE3 %buildroot%_logrotatedir/%name
install -d -m 0755 %buildroot%haproxy_home
install -d -m 0755 %buildroot%haproxy_datadir
install -d -m 0755 %buildroot%_bindir
install -p -m 0755 admin/halog/halog %buildroot%_bindir/halog
cp -p examples/errorfiles/* %buildroot%haproxy_datadir/


%pre
%_sbindir/groupadd -r -f %haproxy_group >/dev/null 2>&1 ||:
%_sbindir/useradd -g %haproxy_group -c 'HA Proxy' \
    -d %haproxy_home -s /dev/null -r -l -M %haproxy_user >/dev/null 2>&1 ||:

%post
%post_service haproxy

%preun
%preun_service haproxy

%files
%doc CHANGELOG LICENSE README doc/architecture.txt doc/configuration.txt doc/intro.txt doc/management.txt doc/proxy-protocol.txt examples/*.cfg
%dir %haproxy_confdir
%dir %haproxy_confdir/conf.d
%config(noreplace) %haproxy_confdir/%name.cfg
%config(noreplace) %_sysconfdir/sysconfig/%name
%config(noreplace) %_logrotatedir/%name
%haproxy_datadir
%_initrddir/%name
%_unitdir/%name.service
%_sbindir/*
%_bindir/*
%_man1dir/*
%attr(-,%haproxy_user,%haproxy_group) %dir %haproxy_home

%changelog
