Name: hass
Version: 2025.1.2
Release: alt2

Summary: Home automation platform
License: APL
Group: System/Servers
Url: https://www.home-assistant.io/

Source0: %name-%version-%release.tar
Source1: pyproject_deps.json

BuildArch: noarch
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
BuildRequires: python3(atomicwrites)
BuildRequires: python3(awesomeversion)
BuildRequires: python3(aiohttp_fast_url_dispatcher)
BuildRequires: python3(black)
BuildRequires: python3(ciso8601)
BuildRequires: python3(dateutil)
BuildRequires: python3(ifaddr)
BuildRequires: python3(jinja2)
BuildRequires: python3(jwt)
BuildRequires: python3(lru)
BuildRequires: python3(numpy)
BuildRequires: python3(orjson)
BuildRequires: python3(slugify)
BuildRequires: python3(tqdm)
BuildRequires: python3(typing_extensions)
BuildRequires: python3(ulid_transform)
BuildRequires: python3(voluptuous)
BuildRequires: python3(voluptuous_serialize)
BuildRequires: python3(yaml)

%package core
Summary: Home automation platform
Group: System/Servers
Requires: python3-module-pip >= 21.0
Requires: python3-module-hass-frontend >= 20250103.0
Requires: python3-module-aiohttp-fast-zlib >= 0.1.1
Requires: python3-module-go2rtc-client >= 0.1.2
Requires: python3(uv)

%package -n python3-module-hass
Summary: Home automation platform
Group: System/Servers
AutoReq: no

%define desc Home Assistant is a home automation platform running on Python 3.\
It is able to track and control all devices at home and offer a platform \
for automating control.

%description
%desc

%description core
%desc
This package contains core modules only.

%description -n python3-module-hass
%desc
This package contains most of Home Assistant modules.

%prep
%setup
python3 -m script.translations develop --all

%build
%pyproject_deps_resync_build
%pyproject_build

%install
%pyproject_install
install -pm0644 -D hass.service %buildroot%_unitdir/hass.service
install -pm0644 -D hass.sysconfig %buildroot%_sysconfdir/sysconfig/hass
mkdir -p %buildroot%_localstatedir/hass

find %buildroot%python3_sitelibdir/homeassistant/components -type f -name manifest.json |\
     sed -re 's,^%buildroot(/.+)/manifest.json,\1,' |sort > all.files
sed -re 's,^,%python3_sitelibdir/homeassistant/,' < precious > core.files
cat all.files core.files |sort |uniq -u > rest.files
sed -re 's,^,%exclude ,' < rest.files > core.files

%pre core
%_sbindir/groupadd -r -f _hass &> /dev/null
%_sbindir/useradd -r -g _hass -d %_localstatedir/hass -s /dev/null \
	-c 'Home Assistant' -n _hass &> /dev/null ||:

%set_python3_req_method strict
%add_python3_req_skip av
%add_python3_req_skip custom_components
%add_python3_req_skip homeassistant.components.cloud
%add_python3_req_skip _typeshed

%files core -f core.files
%_sysconfdir/sysconfig/hass
%_unitdir/hass.service
%_bindir/hass

%python3_sitelibdir/homeassistant
%python3_sitelibdir/homeassistant-%version.dist-info

%dir %attr(0770,root,_hass) %_localstatedir/hass

%files -n python3-module-hass -f rest.files

%changelog
