%def_enable shared
%def_disable static

%define Name HTTrack
%define lname lib%name
%define origver 3.45-3

Name: httrack
Version: 3.45.3
Release: alt1.2
Epoch: 1

Summary: An easy-to-use offline browser utility
License: %gpl2plus
Group: Networking/File transfer

Url: http://www.httrack.com
Source0: %name-%version.tar.gz
Source1: %name.conf
Patch: httrack-3.47.3-alt-makefile.patch
Packager: Led <led@altlinux.ru>

%{?_enable_shared:Requires: %lname = %version-%release}
BuildRequires(pre): rpm-build-licenses
# Automatically added by buildreq on Tue Mar 04 2008
BuildRequires: gcc-c++ zlib-devel ImageMagick

%set_automake_version 1.10
BuildRequires: desktop-file-utils

%description
%Name is an easy-to-use offline browser utility. It allows you to
download a World Wide website from the Internet to a local directory,
building recursively all directories, getting html, images, and other
files from the server to your computer. %Name arranges the original
site's relative link-structure. Simply open a page of the "mirrored"
website in your browser, and you can browse the site from link to link,
as if you were viewing it online. %Name can also update an existing
mirrored site, and resume interrupted downloads. %Name is fully
configurable, and has an integrated help system.


%if_enabled shared
%package -n %lname
Summary: Shared library for %Name
Group: System/Libraries

%description -n %lname
This package contains shared library for %Name.
%endif


%package -n %lname-devel
Summary: Development files for %Name
Group: Development/C
Requires: %lname%{?_disable_shared:-devel-static} = %EVR

%description -n %lname-devel
This package contains development files required for packaging
%Name-based software.


%if_enabled static
%package -n %lname-devel-static
Summary: Static libraries for %Name
Group: Development/C
Requires: %lname-devel = %EVR

%description -n %lname-devel-static
This package contains development libraries required for packaging
statically linked %Name-based software.
%endif


%package -n web%name
Summary: Offline browser - %name and htsserver frontend
Group: Networking/File transfer
Requires: %name = %EVR

%description -n web%name
Offline browser: copy websites to a local directory.


%prep
%setup
%patch -p1


%build
ACLOCAL="aclocal -I m4" %autoreconf
%configure %{subst_enable shared} %{subst_enable static}
%make_build
convert -depth 8 html/server/div/web%name.xpm web%{name}_48.png
for s in 32 24 16; do
    convert -resize ${s}x$s -depth 8 html/server/div/web%name.xpm web%{name}_$s.png
done


%install
%make_install DESTDIR=%buildroot install
mv %buildroot%_docdir/%name{,-%version}
install -m 0644 AUTHORS README %buildroot%_docdir/%name-%version/
install -D -m644 %SOURCE1 %buildroot/%_sysconfdir/%name.conf
for s in 48 32 24 16; do
    install -D -m 0644 {web%{name}_$s,%buildroot%_iconsdir/hicolor/${s}x$s/apps/web%name}.png
done
rm %buildroot%_libdir/%name/*.la
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=FileTransfer \
	%buildroot%_desktopdir/WebHTTrack.desktop


%files
%_docdir/%name-%version
%_bindir/%name
%_datadir/%name
%exclude %_datadir/%name/libtest
%exclude %_datadir/%name/icons
%_man1dir/%name.1*
%config(noreplace) %_sysconfdir/%name.conf


%if_enabled shared
%files -n %lname
%_libdir/*.so.*
%_libdir/%name/*.so.*
%endif


%files -n %lname-devel
%_includedir/%name
%if_enabled shared
%_libdir/*.so
%_libdir/%name/*.so
%endif


%if_enabled static
%files -n %lname-devel-static
%_libdir/*.a
%_libdir/%name/*.a
%endif


%files -n web%name
%_bindir/*
%exclude %_bindir/%name
%_man1dir/*
%exclude %_man1dir/%name.1*
%_datadir/%name/icons
%_pixmapsdir/*
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*


%changelog
