
%define _unpackaged_files_terminate_build 1

Name: hydrogen
Version: 1.2.3
Release: alt1

Summary: Hydrogen Drum Machine
License: GPL
Group: Sound
URL: http://www.hydrogen-music.org

# https://github.com/hydrogen-music/hydrogen.git
Source0: %name-%version.tar
Patch0: %name-%version-%release.patch

BuildRequires: ccmake ctest doxygen gcc-c++ graphviz ladspa_sdk libalsa-devel libarchive-devel libjack-devel liblo-devel liblrdf-devel
BuildRequires: libportaudio2-devel libportmidi-devel librubberband-devel libsndfile-devel libtar-devel libpulseaudio-devel cppunit-devel
BuildRequires: qt5-base-devel qt5-svg-devel qt5-tools-devel qt5-xmlpatterns-devel zlib-devel

BuildRequires: desktop-file-utils

%description
Hydrogen is an advanced sample-based drum machine. Its main
goal is to bring professional yet simple and intuitive
pattern-based drum programming. Its features include:
* Very user-friendly, modular, fast and intuitive graphical
  interface based on Qt5.
* Sample-based stereo audio engine, with import of sound
  samples in wav, au and aiff formats.
* Support of samples in compressed FLAC file.
* Separate command-line interface (h2cli)
* Pattern-based sequencer, with unlimited number of patterns
  and ability to chain patterns into a song.
* Playlist with scripting support.
* Multi layer support for instruments (up to 16 samples
  for each instrument).
* Sample Editor, with basic cut and loop functions.
* JACK, ALSA, PulseAudio, PortAudio, CoreAudio and OSS audio
  drivers.
* Export song to wav, aiff, flac or midi file.

%prep
%setup
%patch0 -p1

%build
%cmake '-DVERSION_SUFFIX:STRING=%release' \
    -DWANT_RUBBERBAND=ON \
    -DWANT_PORTAUDIO=ON -DWANT_PORTMIDI=ON
%cmake_build

%install
%cmake_install

desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=Midi \
	%buildroot%_desktopdir/org.hydrogenmusic.Hydrogen.desktop

%files
%doc -P AUTHORS ChangeLog README.md
%_bindir/*
%_datadir/%name/
%_libdir/*.so
%_desktopdir/*.desktop
%_datadir/metainfo/*.xml
%_iconsdir/hicolor/scalable/apps/*.svg
%_man1dir/%name.1*

# TODO: put headers into separate subpackage
%exclude /usr/include/%name

%changelog
