Name: installer
Version: 1.16.31
Release: alt1

Summary: Installer common parts
License: GPL-2.0-or-later
Group: System/Configuration/Other

Url: http://www.altlinux.org/Installer
Source: %name-%version.tar

BuildRequires: glibc-devel-static

%description
This package contains common installer parts.

%package common-stage2
Summary: Installer common stage2
Group: System/Configuration/Other
Provides: %name-stage2 = %version-%release
Obsoletes: %name-stage2 < %version-%release
# filter out unnecessary dependency
%filter_from_requires /^alterator-wizardface-usermode/d
# because of replace /var/run/alteratord -> /run/alteratord
Requires: alterator >= 5.4.3
# installer-preinstall.desktop
Requires: alterator-preinstall >= 0.9-alt1
# scripts/install2
Requires: alterator-wizardface alterator-backend-x11 >= 0.21-alt2 xinit xinitrc xorg-server xorg-drv-video
Requires: glibc-locales
Requires: installer-scripts-remount-stage2 >= 0.6.8
# scripts/postinstall
Requires: eject
# initinstall.d/10-vt.sh
Requires: bash console-vt-tools
# initinstall.d/25-setup-dhcp.sh
Requires: alterator-hw-functions >= 0.7.8-alt1

Provides: installer-feature-autohostname
Obsoletes: installer-feature-autohostname
Provides: installer-feature-autohostname-stage2
Obsoletes: installer-feature-autohostname-stage2

Provides: installer-feature-cmdline-parameters-stage2
Obsoletes: installer-feature-cmdline-parameters-stage2

Provides: installer-feature-services
Obsoletes: installer-feature-services

Provides: installer-feature-copy-udev-rules-stage3
Obsoletes: installer-feature-copy-udev-rules-stage3


Provides: installer-feature-systemd
Obsoletes: installer-feature-systemd

Provides: installer-feature-setup-network-stage2
Obsoletes: installer-feature-setup-network-stage2
Requires: hostinfo iproute2

Provides: installer-feature-setup-bootloader-stage2
Obsoletes: installer-feature-setup-bootloader-stage2

Requires: xorg-xvfb

# needed for lvm binary, see 11-remount.sh
Requires: libdevmapper-event

Conflicts: alterator-pkg < 1.2-alt1, alterator-sysconfig < 0.6-alt1, alterator-datetime < 4.3.0-alt1

%description common-stage2
This package contains common installer stage2 files and dependencies.

%package common-stage3
Summary: Installer common stage3
Group: System/Configuration/Other
BuildArch: noarch
Provides: %name-stage3 = %version-%release
Obsoletes: %name-stage3 < %version-%release
Requires: alterator-notes

Provides: installer-feature-eth-by-mac-stage3
Obsoletes: installer-feature-eth-by-mac-stage3

Provides: installer-feature-setup-network-stage3
Obsoletes: installer-feature-setup-network-stage3
Requires: alterator-net-eth chkconfig etcnet

%description common-stage3
This package contains common installer stage3 files and dependencies.

%package common-desktop
Summary: Installer files for run on Desktop
Group: System/Configuration/Other
BuildArch: noarch
Requires: installer-common-stage2 = %EVR
Requires: polkit
Requires: installer-alterator-livecd-stage2
Conflicts: livecd-install

%description common-desktop
This package contains installer files for run on Desktop.

%prep
%setup

%build
%make_build

%install
%makeinstall

# install systemd units
pushd systemd
mkdir -p %buildroot/%_unitdir/install2.target.wants
install -m644 install2.target %buildroot/%_unitdir/install2.target
install -m644 install2.service %buildroot/%_unitdir/install2.service
ln -s %_unitdir/install2.service \
	%buildroot/%_unitdir/install2.target.wants/install2.service
popd

touch %buildroot%_datadir/installer-livecd-steps

%files common-stage2
%_sbindir/*
%exclude %_sbindir/install2
%_datadir/install2
%_prefix/libexec/install2
%_prefix/lib/systemd/system/install2.service
%_unitdir/install2.target
%dir %_unitdir/install2.target.wants
%_unitdir/install2.target.wants/install2.service
%exclude %_datadir/install2/livecd-fininstall.d/
%exclude %_datadir/install2/preinstall.d/30-setup-network.sh
%exclude %_datadir/install2/preinstall.d/31-enable-networkmanager.sh

%files common-stage3
%_datadir/install2/preinstall.d/30-setup-network.sh
%_datadir/install2/preinstall.d/31-enable-networkmanager.sh

%files common-desktop
%_sysconfdir/profile.d/zdg-user-dirs-install.sh
%_bindir/install2-desktop
%_desktopdir/install2.desktop
%dir %_datadir/install2/livecd-fininstall.d/
%ghost %_datadir/installer-livecd-steps

%changelog
