%define _unpackaged_files_terminate_build 1

%define prefix /
%define exec_prefix /
%define _prefix /
%define soname 13
Name: ipset
Version: 7.24
Release: alt1

Summary: Tools for managing sets of IP or ports with iptables
License: GPLv2
Group: System/Kernel and hardware
Url: https://ipset.netfilter.org/
VCS: git://git.netfilter.org/ipset.git

Source: %name-%version.tar
Patch: %name-%version-alt.patch
BuildRequires: libmnl-devel

%description
IP sets are a framework inside the Linux kernel, which can be administered
by the ipset utility. Depending on the type, currently an IP set may store IP
addresses, (TCP/UDP) port numbers or IP addresses with MAC addresses in a way,
which ensures lightning speed when matching an entry against a set.

ipset may be the proper tool for you, if you want to
 * store multiple IP addresses or port numbers and match against
   the collection by iptables at one swoop;
 * dynamically update iptables rules against IP addresses or ports
   without performance penalty;
 * express complex IP address and ports based rulesets with one single
   iptables rule and benefit from the speed of IP sets

%package -n lib%{name}%{soname}
Summary: Dynamic library for %name
License: LGPLv2+
Group: Development/C

%description -n lib%{name}%{soname}
The lib%{name}%{soname} package contains the dynamic libraries needed for
applications to use the %name framework.

%package -n lib%{name}-devel
Summary: Header files for lin%name
License: LGPLv2+
Group: Development/C
Requires: lib%{name}%{soname} = %version-%release

%description -n lib%{name}-devel
The lib%{name}6 package contains the header files needed for
developing applications that need to use the %name framework libraries.


%package -n kernel-source-ipset
Summary: Linux ipset modules sources
License: GPLv2+
Group: Development/Kernel
BuildArch: noarch
BuildPreReq: rpm-build-kernel

%description -n kernel-source-ipset
Kernel source modules ipset.

%prep
%setup
%patch -p1

%build
%autoreconf
%configure --with-kmod=no --enable-static=no
%make_build LIBDIR=%_libdir SBINDIR=%_sbindir
%install
%makeinstall_std exec_prefix=/ sbindir=%_sbindir libdir=%_libdir pkgconfigdir=/%_pkgconfigdir
mkdir -p %buildroot%_libdir

tar xvf %SOURCE0
mv %name-%version kernel-source-%name-%version

mkdir -p %kernel_srcdir
tar -cjf %kernel_srcdir/kernel-source-%name-%version.tar.bz2 kernel-source-%name-%version

%files
%doc ChangeLog ChangeLog.ippool README
%_sbindir/ipset
%_sbindir/ipset-translate
%_man8dir/*

%files -n lib%{name}%{soname}
%attr(755,root,root) %_libdir/libipset.so.%{soname}*

%files -n lib%{name}-devel
%_includedir/lib%name/*.h
%_libdir/*.so
%_pkgconfigdir/*.pc
%_man3dir/*

%files -n kernel-source-ipset
%attr(0644,root,root) %kernel_src/kernel-source-%name-%version.tar.bz2

%changelog
