Name: irda-utils
Version: 0.9.18
Release: alt3.qa2

Summary: Utilities for infrared communication between devices
License: GPL-2.0
Group: System/Servers

Url: http://irda.sourceforge.net
Source: ftp://irda.sourceforge.net/pub/irda/%name/%name-%version.tar.gz
Source1: irda.rc
Source2: irda.sysconfig
Patch1: irda-utils-0.9.18-rootonly.patch
Patch2: irda-utils-0.9.16-irkbd.patch
Patch3: irda-utils-gcc3.4-fix.patch
Patch4: irda-utils-rh1.patch
Patch5: irda-utils-0.9.16-alt-irattach-daemonize.patch
Patch6: irda-utils-0.9.18-io.h.diff
Patch7: irda-utils-0.9.18-smcinit.diff
Patch8: irda-utils-0.9.18-alt-as-needed.patch
Patch9: irda-utils-0.9.18-alt-makefile.patch
# https://bugs.gentoo.org/692428
Patch10: irda-utils-0.9.18-SIOCGSTAMP.patch
Patch11: irda-utils-0.9.18-no-inline.patch

Packager: Michael Shigorin <mike@altlinux.org>

Summary(ru_RU.KOI8-R):       

# Automatically added by buildreq on Wed Dec 31 2008
BuildRequires: glib2-devel libpci-devel

%description
IrDA(TM) (Infrared Data Association) is an industry standard for
wireless, infrared communication between devices. IrDA speeds range
from 2400 bps to 4 Mbps, and IrDA can be used by many modern devices
including laptops, LAN adapters, PDAs, printers, and mobile phones.

The Linux-IrDA project is a GPLed implementation, written from
scratch, of the IrDA protocols. Supported IrDA protocols include
IrLAP, IrLMP, IrIAP, IrTTP, IrLPT, IrLAN, IrCOMM and IrOBEX.

The %name package contains a collection of programs that enable
the use of IrDA protocols. Most IrDA features are implemented in the
kernel, so IrDA support must be enabled in the kernel before any IrDA
tools or programs can be used. Some configuration outside the kernel
is required, however, and some IrDA features, like IrOBEX, are
actually implemented outside the kernel.

%prep
%setup
%patch1 -p1 -b .rootonly
#patch2 -p1 -b .irkbd
#patch3 -p1 -b .gcc34
%patch4 -p1 -b .rh1
%patch5 -p1 -b .daemonize
%patch6 -p1 -b .io.h
%patch7 -p0 -b .smcinit
%patch8 -p1 -b .as-needed
%patch9 -p1 -b .makefile
%patch10 -p1
%patch11 -p1

%build
%make_build all ROOT="%buildroot" RPM_OPT_FLAGS="%optflags"

%install
mkdir -p %buildroot{%_bindir,%_sbindir}
%make_install install ROOT="%buildroot" MANDIR="%buildroot%_mandir"

install -pm755 %SOURCE1 %buildroot%_initdir/irda
install -pm644 %SOURCE2 %buildroot%_sysconfdir/sysconfig/irda
mv %buildroot%_sysconfdir/sysconfig/network-scripts/ifcfg-irlan0 .

find -mindepth 2 -name README | while read d; do
	install -p -m644 "$d" "README.`dirname $d | cut -c3-`"
done

%files
%_bindir/*
%_sbindir/*
%config(noreplace) %_initdir/*
%config(noreplace) %_sysconfdir/sysconfig/irda
#config(noreplace) %_sysconfdir/sysconfig/network-scripts/ifcfg-irlan0
%doc README* ifcfg-irlan0
%_man4dir/*
%_man7dir/*
%_man8dir/*

%changelog
