%def_disable    bootstrap
%define         short_version 0.1.9998
%define         svn_revision 3674

ExclusiveArch: %ix86 x86_64

Name:           kBuild
Version:        %short_version.r%svn_revision
Release:        alt1
License:        %gpl3plus
Group:          Development/Other
Summary:        A cross-platform build environment framework for complex tasks
Packager:       Evgeny Sinelnikov <sin@altlinux.ru>
Url:            http://svn.netlabs.org/kbuild

Source:         %name-%version.tar.bz2
Patch2:         kBuild-0.1.3-escape.patch
Patch3:         kBuild-alt-compat.patch
Patch4:         kBuild-use-bison.patch

BuildRequires(pre): rpm-build-licenses
BuildRequires:  cvs flex libacl-devel
BuildRequires: perl-podlators

%if_disabled bootstrap
BuildRequires: kBuild
%endif

%description
This is a GNU make fork with a set of scripts to simplify
complex tasks and portable versions of various UNIX tools to
ensure cross-platform portability.

The goals of the kBuild framework:
- Similar behavior across all supported platforms
- Flexibility, don't create unnecessary restrictions preventing
  ad-hoc solutions
- Makefiles can be simple to write and maintain
- One configuration file for a subtree automatically included
- Target configuration templates as the primary mechanism for
  makefile simplification
- Tools and SDKs for helping out the templates with flexibility
- Non-recursive makefile method by using sub-makefiles

It is used mainly to build VirtualBox OSE packages for RPM Fusion
repository.

Authors:
--------
    Knut St. Osmundsen <bird-kbuild-spam@anduin.net>

%prep
%setup -q
%patch2 -p1
%patch3 -p2
%patch4 -p2
chmod a+x kBuild/env.sh
chmod a+x src/sed/configure

%build
%define bootstrap_mflags %_smp_mflags   \\\
        CFLAGS="%optflags"              \\\
        KBUILD_SVN_REV=%svn_revision    \\\
        KBUILD_VERBOSE=1

%define mflags %bootstrap_mflags        \\\
        NIX_INSTALL_DIR=%_prefix        \\\
        BUILD_TYPE=release              \\\
        MY_INST_MODE=0644               \\\
        MY_INST_BIN_MODE=0755

%if_enabled bootstrap
kBuild/env.sh --full make -f bootstrap.gmk %bootstrap_mflags
kBuild/env.sh kmk rebuild PATH_INS=`pwd` %mflags
%else
kBuild/env.sh kmk %mflags
%endif
pod2man -c 'kBuild for ALT Linux' -r %name-%version dist/debian/kmk.pod |sed -e 's/Debian/ALT Linux/' > kmk.1

%install
kBuild/env.sh kmk install PATH_INS=%buildroot %mflags
install -m 644 -D kmk.1 %buildroot%_man1dir/kmk.1


%files
%_docdir/%name-%short_version
%_bindir/*
%_man1dir/*
%_datadir/%name

%changelog
