Name:     kde-kup
Version:  0.10.0
Release:  alt2

Summary:  KDE-based frontend for bup backup software and incremental backups
License:  GPL-2.0+
Group:    Archiving/Backup

Url:      https://invent.kde.org/system/kup.git
Source:   kup-%version.tar

ExclusiveArch: %ix86 x86_64 %e2k

BuildRequires(pre): rpm-build-kf6
BuildRequires: extra-cmake-modules gcc-c++
BuildRequires: libgit2-devel
BuildRequires: libhttp-parser-devel
BuildRequires: zlib-devel
BuildRequires: openssl-devel
BuildRequires: qt6-base-devel
BuildRequires: qt6-declarative-devel
BuildRequires: kf6-kconfig-devel
BuildRequires: kf6-kdbusaddons-devel
BuildRequires: kf6-ki18n-devel
BuildRequires: kf6-kiconthemes-devel
BuildRequires: kf6-kidletime-devel
BuildRequires: kf6-kio-devel
BuildRequires: kf6-kjobwidgets-devel
BuildRequires: kf6-knotifications-devel
BuildRequires: kf6-kpackage-devel
BuildRequires: plasma6-lib-devel
BuildRequires: plasma6-plasma5support-devel
BuildRequires: kf6-solid-devel
BuildRequires: kf6-kcmutils-devel

Provides: kde4-kup = %EVR
Obsoletes: kde4-kup < %EVR
Provides: kde5-kup = %EVR
Obsoletes: kde5-kup < %EVR

Requires: bup
Requires: par2cmdline

%description
Kup is a KDE-based frontend for the very excellent bup backup software,
that gives you easy and fast incremental backups!

%prep
%setup -n kup-%version

%build
%K6init no_altplace
%K6build -Wno-dev -DQT_MAJOR_VERSION=6 -DQMAKE_EXECUTABLE=%_bindir/qmake-qt6

%install
%K6install
%find_lang --all %name

%files -f %name.lang
%doc README.md
%_K6bin/kup-*
%_K6start/kup-daemon.desktop
%_K6notif/kupdaemon.notifyrc
%_datadir/metainfo/*.appdata.xml
%_K6icon/hicolor/scalable/apps/kup.svg
%_qt6_plugindir/*
%_desktopdir/*.desktop
%_datadir/plasma/plasmoids/org.kde.kupapplet
%_datadir/plasma5support/services/*.operations
%_datadir/qlogging-categories6/kup.categories

%changelog
