%define is_ffmpeg %([ -n "`rpmquery --qf '%%{SOURCERPM}' libavformat-devel 2>/dev/null | grep -e '^libav'`" ] && echo 0 || echo 1)
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

%define rname kdenlive
%define current_ver_mlt %{get_version mlt-utils}

Name: kdenlive
Version: 25.08.3
Release: alt2
%K6init no_altplace man appdata
%add_python3_path %_datadir/%name/scripts

Summary: KDE Non Linear Video Editor
Summary(ru_RU.utf8): Редактор нелинейного видео монтажа для KDE
Summary(ru_UA.utf8): Редактор нелінійного монтажу для KDE
License: GPL-3.0-or-later
Group: Video
URL: http://kdenlive.org/

AutoReq: yes, nopython
AutoProv: yes, nopython nopython3
%add_python3_req_skip opentimelineio
%add_python3_req_skip srt
%add_python3_req_skip vosk
%add_python3_req_skip torch
%add_python3_req_skip whisper
%add_python3_req_skip whisper.utils
%add_python3_req_skip transformers
#
%add_python3_req_skip hydra
%add_python3_req_skip hydra.utils
%add_python3_req_skip omegaconf
%add_python3_req_skip sam2.build_sam
%add_python3_req_skip sam2.sam2_image_predictor
%add_python3_req_skip sam2.sam2_video_predictor
%add_python3_req_skip sam2.utils.misc

Requires: mlt-utils >= %current_ver_mlt mlt-qt6 frei0r-plugins
Requires: recordmydesktop dvdauthor dvgrab genisoimage
Requires: mediainfo
Requires: kf6-kirigami
Requires: icon-theme-breeze kde6-runtime kio-extras
%if %is_ffmpeg
Requires: /usr/bin/ffmpeg /usr/bin/ffplay /usr/bin/ffprobe
%else
Requires: /usr/bin/avconv /usr/bin/avplay /usr/bin/avprobe
%endif

Source: %name-%version.tar
Source1: rttr.tar
Source2: otio.tar
Source3: pybind11.tar
Source4: rapidjson.tar
Source5: Imath.tar
Patch2: alt-find-lumas.patch
Patch3: alt-defaults.patch
Patch4: alt-xdg-current-desktop.patch

BuildRequires(pre): rpm-build-kf6
BuildRequires(pre): libavformat-devel
BuildRequires(pre): mlt-utils
BuildRequires: rpm-build-python3
BuildRequires: extra-cmake-modules
#BuildRequires: git-core
BuildRequires: qt6-declarative-devel qt6-svg-devel qt6-declarative-devel qt6-multimedia-devel qt6-declarative-devel qt6-networkauth-devel
BuildRequires: shared-mime-info libEGL-devel libGLU-devel libv4l-devel
BuildRequires: imath-devel pybind11-devel rapidjson-devel
BuildRequires: libswresample-devel
BuildRequires: mlt7-devel mlt7xx-devel
BuildRequires: kf6-karchive-devel kf6-kauth-devel kf6-kbookmarks-devel kf6-kcodecs-devel kf6-kcompletion-devel kf6-kconfig-devel kf6-kconfigwidgets-devel
BuildRequires: kf6-kcoreaddons-devel kf6-kdbusaddons-devel kf6-kdoctools kf6-kdoctools-devel kf6-kguiaddons-devel kf6-ki18n-devel
BuildRequires: kf6-kiconthemes-devel kf6-kio-devel kf6-kitemviews-devel kf6-kjobwidgets-devel kf6-knewstuff-devel kf6-knotifications-devel
BuildRequires: kf6-knotifyconfig-devel kf6-kplotting-devel kf6-kservice-devel kf6-ktextwidgets-devel kf6-kwidgetsaddons-devel kf6-kxmlgui-devel
BuildRequires: kf6-solid-devel kf6-sonnet-devel kf6-kcrash-devel kf6-kfilemetadata-devel kf6-purpose-devel
BuildRequires: kf6-kdeclarative-devel kf6-kpackage-devel

%description
Kdenlive is a non-linear video editor for GNU/Linux, which supports
DV, HDV and AVCHD(not complete yet) editing.

%description -l ru_RU.utf8
Редактор нелинейного видео монтажа для GNU/Linux

%description -l ru_UA.utf8
Редактор нелінійного монтажу для GNU/Linux

%prep
%setup -q -a2
pushd otio/src/deps
tar xvf %SOURCE3
tar xvf %SOURCE4
tar xvf %SOURCE5
popd
#%patch2 -p1
%patch3 -p1
%patch4 -p1

install -m 0644 %SOURCE1 .
sed -i "s|URL.*github.*rttr.*|URL file://${PWD}/rttr.tar|" rttr.CMakeLists.txt
sed -i "/GIT_REPOSITORY.*OpenTimelineIO/s|GIT_REPOSITORY.*|URL file://${PWD}/otio|" deps/CMakeLists.txt

%build
%K6build \
    -DOTIO_AUTOMATIC_SUBMODULES:BOOL=OFF \
    -DOTIO_DEPENDENCIES_INSTALL:BOOL=OFF \
    -DOTIO_CXX_INSTALL:BOOL=OFF \
    #

%install
%K6install

%find_lang %name --with-kde --all-name
sed -i '/[[:space:]]\/.*[[:space:]]/s|[[:space:]]\(\/.*$\)| "\1"|' %name.lang

%files -f %name.lang
%doc AUTHORS LICENSES/*
%_K6bin/*
%_K6plug/kf6/thumbcreator/*mlt*.so
%_K6qml/org/kde/kdenlive/
%_K6xdgapp/*.desktop
%_datadir/%name
%_K6cfg/*kdenlive*
%_iconsdir/*/*/*/*.*
%_K6notif/*rc
%_K6xdgmime/*.xml
%_man1dir/kdenlive*
%_datadir/metainfo/org.kde.kdenlive.appdata.xml
%_datadir/qlogging-categories6/*.categories
%_datadir/knsrcfiles/*.knsrc
%_datadir/qlogging-categories?/*.*categories

%changelog
