%define rname kjobwidgets
%def_disable python
%if_enabled python
%define sipver2 %(rpm -q --qf '%%{VERSION}' python-module-sip)
%define sipver3 %(rpm -q --qf '%%{VERSION}' python3-module-sip)
%endif

Name: kf5-%rname
Version: 5.116.0
Release: alt1
%K5init altplace

Group: System/Libraries
Summary: KDE Frameworks 5 showing progress of asynchronous jobs
Url: http://www.kde.org
License: GPLv2+ / LGPLv2+

Source: %rname-%version.tar

# Automatically added by buildreq on Tue Feb 10 2015 (-bi)
# optimized out: cmake cmake-modules elfutils libEGL-devel libGL-devel libICE-devel libSM-devel libX11-devel libXau-devel libXext-devel libXfixes-devel libXi-devel libXrender-devel libXt-devel libcloog-isl4 libqt5-core libqt5-dbus libqt5-gui libqt5-test libqt5-widgets libqt5-x11extras libqt5-xml libstdc++-devel python-base qt5-base-devel qt5-tools ruby ruby-stdlibs xorg-kbproto-devel xorg-xf86miscproto-devel xorg-xproto-devel
#BuildRequires: extra-cmake-modules gcc-c++ kf5-kcoreaddons-devel kf5-kwidgetsaddons-devel libXScrnSaver-devel libXcomposite-devel libXcursor-devel libXdamage-devel libXdmcp-devel libXft-devel libXinerama-devel libXmu-devel libXpm-devel libXrandr-devel libXtst-devel libXv-devel libXxf86misc-devel libXxf86vm-devel libxkbfile-devel python-module-google qt5-tools-devel qt5-x11extras-devel rpm-build-ruby
BuildRequires(pre): rpm-build-kf5
%if_enabled python
BuildRequires(pre): python3-module-sip-devel
BuildRequires: python3-module-kcoreaddons-devel python3-module-PyQt5-devel
%endif
BuildRequires: extra-cmake-modules gcc-c++
BuildRequires: kf5-kcoreaddons-devel kf5-kwidgetsaddons-devel qt5-tools-devel
BuildRequires: libXScrnSaver-devel libXcomposite-devel libXcursor-devel libXdamage-devel
BuildRequires: libXdmcp-devel libXft-devel libXinerama-devel libXmu-devel libXpm-devel libXrandr-devel
BuildRequires: libXtst-devel libXv-devel libXxf86misc-devel libXxf86vm-devel
BuildRequires: libxkbfile-devel
BuildRequires: qt5-x11extras-devel

%description
KJobWIdgets provides widgets for showing progress of asynchronous jobs.

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kf5-filesystem
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: kf5-kcoreaddons-devel
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n libkf5jobwidgets
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n libkf5jobwidgets
KF5 library

%if_enabled python
%package -n python-module-%rname
Summary: Python bindings for KJobWidgets
License: GPLv2+ / LGPLv2+
Group: Development/Python
Requires: %name-common = %version-%release
Requires: python-module-pykf5
Requires: python-module-sip = %sipver2
%description -n python-module-%rname
Python bindings for KJobWidgets

%package -n python-module-%rname-devel
Summary: Sip files for python-module-%rname
Group: Development/Python
BuildArch: noarch
%description -n python-module-%rname-devel
Sip files for python-module-%rname

%package -n python3-module-%rname
Summary: Python3 bindings for KJobWidgets
License: GPLv2+ / LGPLv2+
Group: Development/Python3
Requires: %name-common = %version-%release
Requires: python3-module-pykf5
Requires: python3-module-sip = %sipver3
%description -n python3-module-%rname
Python3 bindings for KJobWidgets

%package -n python3-module-%rname-devel
Summary: Sip files for python3-module-%rname
Group: Development/Python3
BuildArch: noarch
%description -n python3-module-%rname-devel
Sip files for python3-module-%rname
%endif

%prep
%setup -n %rname-%version

%build
%K5build

%install
%K5install
%find_lang %name --all-name
%K5find_qtlang %name --all-name
rm -rf %buildroot%_libdir/*/*/*/__*


%files common -f %name.lang
%doc LICENSES/* README.md
%_datadir/qlogging-categories5/*.*categories

%files devel
#%_K5inc/kjobwidgets_version.h
%_K5inc/KJobWidgets/
%_K5link/lib*.so
%_K5lib/cmake/KF5JobWidgets
%_K5archdata/mkspecs/modules/qt_KJobWidgets.pri
%_K5dbus_iface/*.xml

%files -n libkf5jobwidgets
%_K5lib/libKF5JobWidgets.so.*

%if_enabled python
#%files -n python-module-%rname
#%python_sitelibdir/PyKF5/*.so
#%files -n python-module-%rname-devel
#%_datadir/sip/PyKF5/KJobWidgets/
%files -n python3-module-%rname
%python3_sitelibdir/PyKF5/*.so
%files -n python3-module-%rname-devel
%_datadir/sip3/PyKF5/KJobWidgets/
%endif

%changelog
