%define rname kpty

%def_enable utempter
%define helperpath %_libexecdir/utempter/utempter

Name: kf5-%rname
Version: 5.116.0
Release: alt1
%K5init altplace

Group: System/Libraries
Summary: KDE Frameworks 5 interfacing with pseudo terminal devices
Url: http://www.kde.org
License: GPLv2+ / LGPLv2+

Source: %rname-%version.tar

# Automatically added by buildreq on Fri Feb 13 2015 (-bi)
# optimized out: cmake cmake-modules elfutils libcloog-isl4 libqt5-core libqt5-test libstdc++-devel python-base ruby ruby-stdlibs
#BuildRequires: extra-cmake-modules gcc-c++ kf5-kcoreaddons-devel kf5-ki18n-devel libutempter-devel python-module-google qt5-base-devel rpm-build-ruby
BuildRequires(pre): rpm-build-kf5 rpm-build-ubt
%if_enabled utempter
BuildRequires: libutempter-devel
%endif
BuildRequires: extra-cmake-modules gcc-c++ kf5-kcoreaddons-devel kf5-ki18n-devel qt5-base-devel

%description
This library provides primitives to interface with pseudo terminal devices
as well as a KProcess derived class for running child processes and
communicating with them using a pty.

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kf5-filesystem
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n libkf5pty
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
Requires: utempter
%description -n libkf5pty
KF5 library


%prep
%setup -n %rname-%version

%if_disabled utempter
# disable to find utempter executable
sed -i '/find_file.*UTEMPTER_EXECUTABLE/s/UTEMPTER_EXECUTABLE/UTEMPTER_EXECUTABLE_DISABLE/' cmake/FindUTEMPTER.cmake
%endif

%build
%K5build \
%if_enabled utempter
    -DUTEMPTER_EXECUTABLE=%helperpath \
%endif
    #

%install
%K5install
%find_lang %name --all-name
%K5find_qtlang %name --all-name

%files common -f %name.lang
%doc LICENSES/* README.md
%_datadir/qlogging-categories5/*.*categories

%files devel
#%_K5inc/kpty_version.h
%_K5inc/KPty/
%_K5link/lib*.so
%_K5lib/cmake/KF5Pty
%_K5archdata/mkspecs/modules/qt_KPty.pri

%files -n libkf5pty
%_K5lib/libKF5Pty.so.*

%changelog
